<?php
class Site_model extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function get_marcas($activo = FALSE) {
        $this->db->select('marcas.id AS id,
                           marcas.orden AS orden,
                           marcas.marca AS marca,
                           marcas.descripcion AS descripcion,
                           marcas.description AS description,
                           marcas.imagen AS imagen,
                           marcas.thumb AS thumb,
                           marcas.url AS url,
                           marcas.activo AS activo');
        $this->db->from('marcas');
        if($activo) {
            $this->db->where('marcas.activo', $activo);
        }
        $this->db->order_by("marcas.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_categorias_activas() {
        $this->db->select('categorias.id AS id,
                           categorias.orden AS orden,
                           categorias.categoria AS categoria,
                           categorias.url AS url,
                           categorias.activo AS activo');
        $this->db->from('categorias');
        $this->db->where('categorias.activo', 1);
        $this->db->order_by("categorias.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_subcategorias_activas() {
        $this->db->select('subcategorias.id AS id,
                           subcategorias.orden AS orden,
                           subcategorias.id_categoria AS id_categoria,
                           subcategorias.subcategoria AS subcategoria,
                           subcategorias.url AS url,
                           subcategorias.activo AS activo,
                           subcategorias.thumb AS thumb');
        $this->db->from('subcategorias');
        $this->db->where('subcategorias.activo', 1);
        $this->db->order_by("subcategorias.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    // video
    public function get_video() {
        $this->db->select('video.id AS id,
                           video.utc AS utc,
                           video.video AS video,
                           video.imagen AS imagen,
                           video.autoplay AS autoplay,
                           video.mute AS mute,
                           video.controls AS controls,
                           video.vloop AS vloop,
                           video.activo AS activo');
        $this->db->from('video');
        $this->db->order_by("video.utc", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_patrocinadores() {
        $this->db->select('patrocinadores.id AS id,
                           patrocinadores.orden AS orden,
                           patrocinadores.patrocinador AS patrocinador,
                           patrocinadores.imagen AS imagen,
                           patrocinadores.thumb AS thumb');
        $this->db->from('patrocinadores');
        $this->db->order_by("patrocinadores.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_categoria($id = FALSE, $url = FALSE, $activo = FALSE) {
        if ($url === FALSE AND $url === FALSE)
        {
            return FALSE;
        }

        if($id AND !$url) {
            if($activo) {
                $activo = 1;
                $query = $this->db->get_where('categorias', array('id' => $id, 'activo' => $activo));
            } else {
                $query = $this->db->get_where('categorias', array('id' => $id));
            }
        } else if(!$id AND $url) {
            if($activo) {
                $activo = 1;
                $query = $this->db->get_where('categorias', array('url' => $url, 'activo' => $activo));
            } else {
                $query = $this->db->get_where('categorias', array('url' => $url));
            }
        } else {
            if($activo) {
                $activo = 1;
                $query = $this->db->get_where('categorias', array('id' => $id, 'url' => $url, 'activo' => $activo));
            } else {
                $query = $this->db->get_where('categorias', array('id' => $id, 'url' => $url));
            }
        }



        return $query->row_array();
    }

    public function get_subcategoria($id = FALSE, $id_categoria = FALSE, $url = FALSE, $activo = FALSE) {
        if ($id === FALSE)
        {
            if($id_categoria === FALSE OR $url === FALSE) {
                return FALSE;
            } else {
                if($activo) {
                    $activo = 1;
                    $query = $this->db->get_where('subcategorias', array('id_categoria' => $id_categoria, 'url' => $url, 'activo' => $activo));
                } else {
                    $query = $this->db->get_where('subcategorias', array('id_categoria' => $id_categoria, 'url' => $url));
                }
            }
        } else {
            if($activo) {
                $activo = 1;
                $query = $this->db->get_where('categorias', array('id' => $id, 'activo' => $activo));
            } else {
                $query = $this->db->get_where('categorias', array('id' => $id));
            }
        }



        return $query->row_array();
    }

    public function get_promociones_productos($id = FALSE, $activo = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           promociones.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('promociones');
        $this->db->join('promociones_productos', 'promociones_productos.id_promocion = promociones.id');
        $this->db->join('productos', 'productos.id = promociones_productos.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        $this->db->where('promociones.id', $id);
        if($activo) {
            $this->db->where('productos.activo', $activo);
        }
        $this->db->order_by("promociones_productos.orden", "asc");


        $query = $this->db->get();
        return $query->result_array();
    }


    public function get_productos_random($numero = FALSE, $activo = FALSE) {
        if ($numero === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           subcategorias.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('subcategorias');
        $this->db->join('productos_subcategorias', 'productos_subcategorias.id_subcategoria = subcategorias.id');
        $this->db->join('productos', 'productos.id = productos_subcategorias.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        //$this->db->where('subcategorias.id', $id_subcategoria);
        if($activo) {
            $this->db->where('productos.activo', $activo);
        }
        $this->db->order_by("productos.orden", "random");
        $this->db->limit($numero);


        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_productos_number($numero = FALSE, $activo = FALSE) {
        if ($numero === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url');
        $this->db->from('productos');
        if($activo) {
            $this->db->where('productos.activo', $activo);
        }
        $this->db->order_by("productos.orden", "asc");
        $this->db->limit($numero);


        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_productos($id_subcategoria = FALSE, $activo = FALSE) {
        if ($id_subcategoria === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           subcategorias.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('subcategorias');
        $this->db->join('productos_subcategorias', 'productos_subcategorias.id_subcategoria = subcategorias.id');
        $this->db->join('productos', 'productos.id = productos_subcategorias.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        $this->db->where('subcategorias.id', $id_subcategoria);
        if($activo) {
            $this->db->where('productos.activo', $activo);
        }
        $this->db->order_by("productos.orden", "asc");


        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_productos_buscar($query = FALSE, $activo = FALSE) {
        if ($query === FALSE)
        {
            return FALSE;
        }

        //$query = '+'.$query;
        //$query = str_replace(' ', ' +', $query);

        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.tags AS tags,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           productos.activo AS activo,
                           subcategorias.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('subcategorias');
        $this->db->join('productos_subcategorias', 'productos_subcategorias.id_subcategoria = subcategorias.id');
        $this->db->join('productos', 'productos.id = productos_subcategorias.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        //$this->db->where('subcategorias.id', $id_subcategoria);
        if($activo) {
            $this->db->where('productos.activo', 1);
        }
        //$this->db->where('MATCH (marcas.marca,productos.nombre,productos.descripcion,productos.tags) AGAINST ("'.$query.'*" IN BOOLEAN MODE)', NULL, FALSE);
        $this->db->like('marcas.marca', $query);
        $this->db->or_like('productos.codigo', $query);
        $this->db->or_like('productos.nombre', $query);
        $this->db->or_like('productos.descripcion', $query);
        $this->db->or_like('productos.tags', $query);
        $this->db->group_by("productos.nombre");
        $this->db->order_by("productos.orden", "asc");


        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_producto($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.precio AS precio,
                           productos.tallas AS tallas,
                           productos.video AS video,
                           productos.tags AS tags,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           productos.activo AS activo,
                           marcas.id AS m_id,
                           marcas.marca AS nombre_marca');
        $this->db->from('productos');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        $this->db->where('productos.id', $id);
        $this->db->where('productos.activo', 1);

        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_banners($activo = FALSE) {
        $this->db->select('banners.id AS id,
                           banners.orden AS orden,
                           banners.texto AS texto,
                           banners.texto_2 AS texto_2,
                           banners.imagen AS imagen,
                           banners.producto AS producto,
                           banners.activo AS activo,
                           productos.id AS producto_id,
                           productos.url AS producto_url');
        $this->db->from('banners');
        $this->db->join('productos', 'productos.id = banners.producto', 'left');
        if($activo) {
            $this->db->where('banners.activo', $activo);
        }
        $this->db->order_by("banners.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_descargas($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('descargas.id AS id,
                           descargas.orden AS orden,
                           descargas.id_producto AS id_producto,
                           descargas.nombre AS nombre,
                           descargas.archivo AS archivo');
        $this->db->from('descargas');
        $this->db->where('descargas.id_producto', $id);
        $this->db->order_by("descargas.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_infos($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('info.id AS id,
                           info.orden AS orden,
                           info.id_producto AS id_producto,
                           info.tipo AS tipo,
                           info.nombre AS nombre,
                           info.contenido AS contenido');
        $this->db->from('info');
        $this->db->where('info.id_producto', $id);
        $this->db->order_by("info.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_promociones($activo = FALSE) {

        $this->db->select('promociones.id AS id,
                           promociones.orden AS orden,
                           promociones.nombre AS nombre,
                           promociones.descripcion AS descripcion,
                           promociones.producto_1 AS producto_1,
                           promociones.producto_2 AS producto_2,
                           promociones.imagen AS imagen,
                           promociones.thumb AS thumb,
                           promociones.imagenp AS imagenp,
                           promociones.thumbp AS thumbp,
                           promociones.url AS url');
        $this->db->from('promociones');

        if($activo) {
            $this->db->where('promociones.activo', $activo);
        }
        $this->db->order_by("promociones.orden", "asc");


        $query = $this->db->get();
        $promo = $query->result_array();

        if($promo) {
            $i = 0;
            foreach($promo as $p) {
                    if($p['producto_1']) {

                        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.precio AS precio,
                           productos.tallas AS tallas,
                           productos.video AS video,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           productos.activo AS activo');
                        $this->db->from('productos');
                        $this->db->where('productos.id', $p['producto_1']);
                        $this->db->where('productos.activo', 1);

                        $prod = $this->db->get();
                        $f[$i]['producto_1'] = $prod->row_array();
                    }

                if($p['producto_2']) {

                    $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.precio AS precio,
                           productos.tallas AS tallas,
                           productos.video AS video,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           productos.activo AS activo');
                    $this->db->from('productos');
                    $this->db->where('productos.id', $p['producto_2']);
                    $this->db->where('productos.activo', 1);

                    $prod = $this->db->get();
                    $f[$i]['producto_2'] = $prod->row_array();
                }

                    $f[$i]['promo'] = $p;
                    $i++;
                }
            return $f;
        } else {
            return FALSE;
        }
    }
    // promociones flyer .....................................................................................................................................
    public function get_promociones_flyer($activo = FALSE) {

        $this->db->select('promociones_flyer.id AS id,
                           promociones_flyer.orden AS orden,
                           promociones_flyer.nombre AS nombre,
                           promociones_flyer.enlace AS enlace,
                           promociones_flyer.imagen AS imagen,
                           promociones_flyer.thumb AS thumb,
                           promociones_flyer.url AS url,
                           promociones_flyer.activo AS activo');

        $this->db->from('promociones_flyer');

        if($activo) {
            $this->db->where('promociones_flyer.activo', $activo);
        }

        $this->db->order_by("promociones_flyer.orden", "asc");


        $query = $this->db->get();
        $promo = $query->result_array();
        return $promo;
    }

    public function get_promocion($url = FALSE) {
        if ($url === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('promociones', array('url' => $url));
        return $query->row_array();
    }

    public function get_galerias($id_producto = FALSE) {
        if ($id_producto === FALSE)
        {
            return FALSE;
        }
        $this->db->select('galerias.id AS id,
                           galerias.orden AS orden,
                           galerias.id_producto AS id_producto,
                           galerias.color AS color');
        $this->db->from('galerias');
        $this->db->where('galerias.id_producto', $id_producto);
        $this->db->order_by("galerias.orden", "asc");


        $query = $this->db->get();
        $gal = $query->result_array();

        if($gal) {
            $i = 0;
            foreach($gal as $g) {

                $this->db->select('imagenes.id AS id,
                           imagenes.orden AS orden,
                           imagenes.id_galeria AS id_galeria,
                           imagenes.grande AS grande,
                           imagenes.imagen AS imagen,
                           imagenes.thumb AS thumb');
                $this->db->from('imagenes');
                $this->db->where('imagenes.id_galeria', $g['id']);
                $this->db->order_by("imagenes.orden", "asc");

                $img = $this->db->get();
                $f[$i]['imagenes'] = $img->result_array();

                $f[$i]['gal'] = $g;
                $i++;
            }
            return $f;
        } else {
            return FALSE;
        }
    }


}