<?php
class Admin_model extends CI_Model {

    public function __construct() {
        $this->load->database();
    }

    public function get_producto($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.precio AS precio,
                           productos.tallas AS tallas,
                           productos.video AS video,
                           productos.tags AS tags,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           productos.activo AS activo,
                           marcas.id AS m_id');
        $this->db->from('productos');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        $this->db->where('productos.id', $id);
        //$this->db->where('productos.activo', 1);

        //$query = $this->db->get_where('productos', array('id' => $id));
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_productos() {
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb');
        $this->db->from('productos');
        $this->db->order_by("productos.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function ob_productos($limit = 10, $offset = 0) {
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.activo AS activo,
                           productos.thumb AS thumb');
        $this->db->from('productos');
        $this->db->order_by("productos.orden", "asc");
        $this->db->limit($limit, $offset);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function ob_numero_productos() {
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb');
        $this->db->from('productos');

        return $this->db->get()->num_rows();
    }

    public function ob_productos_buscar($query = FALSE, $limit = 10, $offset = 0) {
        if ($query === FALSE)
        {
            return FALSE;
        }

        //$query = '+'.$query;
        //$query = str_replace(' ', ' +', $query);

        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.tags AS tags,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           subcategorias.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('subcategorias');
        $this->db->join('productos_subcategorias', 'productos_subcategorias.id_subcategoria = subcategorias.id');
        $this->db->join('productos', 'productos.id = productos_subcategorias.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        //$this->db->where('MATCH (marcas.marca,productos.codigo,productos.nombre,productos.descripcion,productos.tags) AGAINST ("'.$query.'" IN BOOLEAN MODE)', NULL, FALSE);
        $this->db->like('marcas.marca', $query);
        $this->db->or_like('productos.codigo', $query);
        $this->db->or_like('productos.nombre', $query);
        $this->db->or_like('productos.descripcion', $query);
        $this->db->or_like('productos.tags', $query);
        $this->db->group_by("productos.nombre");
        $this->db->order_by("productos.orden", "asc");
        $this->db->limit($limit, $offset);


        $query = $this->db->get();
        return $query->result_array();
    }

    public function ob_numero_productos_buscar($query = FALSE) {
        if ($query === FALSE)
        {
            return FALSE;
        }

        $query = '+'.$query;
        $query = str_replace(' ', ' +', $query);

        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.tags AS tags,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           subcategorias.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('subcategorias');
        $this->db->join('productos_subcategorias', 'productos_subcategorias.id_subcategoria = subcategorias.id');
        $this->db->join('productos', 'productos.id = productos_subcategorias.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        $this->db->where('MATCH (marcas.marca,productos.codigo,productos.nombre,productos.descripcion,productos.tags) AGAINST ("'.$query.'" IN BOOLEAN MODE)', NULL, FALSE);
        $this->db->group_by("productos.nombre");
        $this->db->order_by("productos.orden", "asc");

        return $this->db->get()->num_rows();
    }

    public function create_producto($categoria = FALSE, $id_marca = FALSE, $codigo = '', $nombre = FALSE, $descripcion = '', $precio = '', $tallas = '', $video = '', $tags = '', $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo) {
        if ($categoria === FALSE OR $id_marca === FALSE OR $nombre === FALSE OR $imagen === FALSE OR $thumb === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM productos ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_marca' =>  $id_marca,
            'codigo' =>  $codigo,
            'nombre' => $nombre,
            'descripcion' => $descripcion,
            'precio'    => $precio,
            'tallas'      => $tallas,
            'video'    => $video,
            'tags'      => $tags,
            'imagen' => $imagen,
            'thumb' =>  $thumb,
            'url' => $url,
            'activo' => $activo
        );

        $data['orden'] = $o;

        $this->db->trans_start();

        $query = $this->db->insert('productos', $data);

        $insert_id = $this->db->insert_id();
        $this->db->trans_complete();

        if( $query) {
            //foreach($categoria as $c) {

            //}
            $datos['id_producto'] = $insert_id;

            foreach($categoria as $c) {
                $datos['id_subcategoria'] = $c;
                $this->db->insert('productos_subcategorias', $datos);
            }
            //$datos['id_subcategoria'] = $categoria;

            //$query = $this->db->insert('productos_subcategorias', $datos);
            return $query;
        } else {
            return $query;
        }
    }

    public function edit_producto($id = FALSE, $categoria = FALSE, $id_marca = FALSE, $codigo = '', $nombre = FALSE, $descripcion = '', $precio = '', $tallas = '', $video = '', $tags = '', $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo) {
        if ($id === FALSE OR $categoria === FALSE OR $id_marca === FALSE OR $nombre === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'id_marca' =>  $id_marca,
            'codigo' =>  $codigo,
            'nombre' => $nombre,
            'descripcion' => $descripcion,
            'precio'    => $precio,
            'tallas'      => $tallas,
            'video'    => $video,
            'tags'      => $tags,
            'url' => $url,
            'activo' => $activo
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('productos', $data);

        if( $query) {
            $query2 = $this->db->delete('productos_subcategorias', array('id_producto' => $id));
            if($query2) {
                $datos['id_producto'] = $id;
                foreach($categoria as $c) {

                    $datos['id_subcategoria'] = $c;
                    $this->db->insert('productos_subcategorias', $datos);
                }

                //$datos['id_producto'] = $id;
                //$datos['id_subcategoria'] = $categoria;

                //$queryX = $this->db->insert('productos_subcategorias', $datos);
                return TRUE;
            } else {
                return $query;
            }
        } else {
            return $query;
        }

        //return $query;
    }

    public function get_producto_subcategorias($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos_subcategorias.id AS id,
                           productos_subcategorias.id_producto AS id_producto,
                           productos_subcategorias.id_subcategoria AS id_subcategoria');
        $this->db->from('productos_subcategorias');
        $this->db->where('productos_subcategorias.id_producto', $id);
        $this->db->order_by("productos_subcategorias.id", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_galeria($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $this->db->select('galerias.id AS id,
                           galerias.id_producto AS id_producto,
                           galerias.color AS color,
                           productos.id AS p_id,
                           productos.nombre AS p_nombre,
                           productos.imagen AS p_imagen,
                           productos.thumb AS p_thumb');
        $this->db->from('galerias');
        $this->db->join('productos', 'productos.id = galerias.id_producto');
        $this->db->where('galerias.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function edit_galeria($id = FALSE, $color = FALSE) {
        if ($id === FALSE OR $color === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'color' => $color
        );

        $this->db->where('id', $id);
        $query = $this->db->update('galerias', $data);

        return $query;
    }

    public function get_galerias($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('galerias.id AS id,
                           galerias.orden AS orden,
                           galerias.id_producto AS id_producto,
                           galerias.color AS color');
        $this->db->from('galerias');
        $this->db->where('galerias.id_producto', $id);
        $this->db->order_by("galerias.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function eliminar_galeria($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $ci = get_instance();

        $imagenes = $this->db->get_where('imagenes', array('id_galeria' => $id));
        $imagenes = $imagenes->result_array();

            foreach($imagenes as $i) {
                    $grande = "./img/productos/".$i['grande'];
                    $imagen = "./img/productos/".$i['imagen'];
                    $thumb = "./img/productos/".$i['thumb'];
                    eliminar_archivo($grande);
                    eliminar_archivo($imagen);
                    eliminar_archivo($thumb);
            }
            $this->db->delete('imagenes', array('id_galeria' => $id));


        $query = $this->db->delete('galerias', array('id' => $id));
        return $query;
    }

    public function create_galeria($id_producto = FALSE, $color = FALSE) {
        if ($id_producto === FALSE OR $color === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM galerias ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_producto' => $id_producto,
            'color' => $color
        );

        $data['orden'] = $o;

        $query = $this->db->insert('galerias', $data);
        return $query;
    }

    public function get_imagen($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('imagenes', array('id' => $id));
        return $query->row_array();
    }

    public function create_imagen($id_galeria = FALSE, $grande = FALSE, $imagen = FALSE, $thumb = FALSE) {
        if ($id_galeria === FALSE OR $grande === FALSE OR $imagen === FALSE OR $thumb === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM imagenes ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_galeria' =>  $id_galeria,
            'grande' => $grande,
            'imagen' => $imagen,
            'thumb' =>  $thumb
        );

        $data['orden'] = $o;

        $query = $this->db->insert('imagenes', $data);
        return $query;
    }

    public function eliminar_imagen($id = FALSE, $id_galeria = FALSE) {
        if ($id === FALSE OR $id_galeria === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('imagenes', array('id' => $id, 'id_galeria' => $id_galeria));
        return $query;
    }

    public function get_imagenes($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('imagenes.id AS id,
                           imagenes.orden AS orden,
                           imagenes.id_galeria AS id_galeria,
                           imagenes.grande AS grande,
                           imagenes.imagen AS imagen,
                           imagenes.thumb AS thumb');
        $this->db->from('imagenes');
        $this->db->where('imagenes.id_galeria', $id);
        $this->db->order_by("imagenes.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_descarga($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('descargas', array('id' => $id));
        return $query->row_array();
    }

    public function eliminar_descarga($id = FALSE, $id_producto = FALSE) {
        if ($id === FALSE OR $id_producto === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('descargas', array('id' => $id, 'id_producto' => $id_producto));
        return $query;
    }

    public function get_descargas($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('descargas.id AS id,
                           descargas.orden AS orden,
                           descargas.id_producto AS id_producto,
                           descargas.nombre AS nombre,
                           descargas.archivo AS archivo');
        $this->db->from('descargas');
        $this->db->where('descargas.id_producto', $id);
        $this->db->order_by("descargas.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function create_descarga($id_producto = FALSE, $nombre = FALSE, $archivo = FALSE) {
        if ($id_producto === FALSE OR $nombre === FALSE OR $archivo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM descargas ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_producto' =>  $id_producto,
            'nombre' => $nombre,
            'archivo' =>  $archivo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('descargas', $data);
        return $query;
    }

    public function get_info($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('info', array('id' => $id));
        return $query->row_array();
    }

    public function get_infos($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('info.id AS id,
                           info.orden AS orden,
                           info.id_producto AS id_producto,
                           info.tipo AS tipo,
                           info.nombre AS nombre,
                           info.contenido AS contenido');
        $this->db->from('info');
        $this->db->where('info.id_producto', $id);
        $this->db->order_by("info.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function create_info($id_producto = FALSE, $tipo = FALSE, $nombre = FALSE, $contenido = '') {
        if ($id_producto === FALSE OR $nombre === FALSE OR $tipo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM info ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_producto' =>  $id_producto,
            'tipo' =>  $tipo,
            'nombre' => $nombre,
            'contenido' =>  $contenido
        );

        $data['orden'] = $o;

        $query = $this->db->insert('info', $data);
        return $query;
    }

    public function eliminar_info($id = FALSE, $id_producto = FALSE) {
        if ($id === FALSE OR $id_producto === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('info', array('id' => $id, 'id_producto' => $id_producto));
        return $query;
    }

    public function get_promociones() {
        $this->db->select('promociones.id AS id,
                           promociones.orden AS orden,
                           promociones.nombre AS nombre,
                           promociones.descripcion AS descripcion,
                           promociones.producto_1 AS producto_1,
                           promociones.producto_2 AS producto_2,
                           promociones.imagen AS imagen,
                           promociones.thumb AS thumb,
                           promociones.url AS url,
                           promociones.activo AS activo');
        $this->db->from('promociones');
        $this->db->order_by("promociones.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_promocion($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('promociones', array('id' => $id));
        return $query->row_array();
    }
/*
    public function create_promocion($nombre = FALSE, $descripcion = '', $producto_1 = 0, $producto_2 = 0, $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($nombre === FALSE OR $imagen === FALSE OR $thumb === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM promociones ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'nombre' =>  $nombre,
            'descripcion' =>  $descripcion,
            'producto_1' =>  $producto_1,
            'producto_2' =>  $producto_2,
            'imagen' => $imagen,
            'thumb' =>  $thumb,
            'url' =>  $url,
            'activo' => $activo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('promociones', $data);
        return $query;
    }
*/
    public function create_promocion($nombre = FALSE, $imagenp = FALSE, $thumbp = FALSE, $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($nombre === FALSE OR $imagen === FALSE OR $thumb === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM promociones ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'nombre' =>  $nombre,
            'imagenp' => $imagenp,
            'thumbp' =>  $thumbp,
            'imagen' => $imagen,
            'thumb' =>  $thumb,
            'url' =>  $url,
            'activo' => $activo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('promociones', $data);
        return $query;
    }

    public function edit_promocion($id = FALSE, $nombre = FALSE, $imagenp = FALSE, $thumbp = FALSE, $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($id === FALSE OR $nombre === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'nombre' => $nombre,
            'url' => $url,
            'activo'    => $activo
        );

        if($imagenp) {
            $data['imagenp'] = $imagenp;
        }

        if($thumbp) {
            $data['thumbp'] = $thumbp;
        }

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('promociones', $data);

        return $query;
    }
/*
    public function edit_promocion($id = FALSE, $nombre = FALSE, $descripcion = '', $producto_1 = 0, $producto_2 = 0, $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($id === FALSE OR $nombre === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'nombre' => $nombre,
            'descripcion' => $descripcion,
            'producto_1' => $producto_1,
            'producto_2' => $producto_2,
            'url' => $url,
            'activo'    => $activo
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('promociones', $data);

        return $query;
    }
*/


    // Promociones Flyer
    public function get_promociones_flyer() {
        $this->db->select('promociones_flyer.id AS id,
                           promociones_flyer.orden AS orden,
                           promociones_flyer.nombre AS nombre,
                           promociones_flyer.imagen AS imagen,
                           promociones_flyer.thumb AS thumb,
                           promociones_flyer.url AS url,
                           promociones_flyer.activo AS activo');
        $this->db->from('promociones_flyer');
        $this->db->order_by("promociones_flyer.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }
    public function create_flyer($nombre = FALSE, $enlace = '', $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($nombre === FALSE OR $imagen === FALSE OR $thumb === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM promociones_flyer ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'nombre' =>  $nombre,
            'enlace' =>  $enlace,
            'imagen' => $imagen,
            'thumb' =>  $thumb,
            'url' =>  $url,
            'activo' => $activo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('promociones_flyer', $data);
        return $query;
    }
    public function get_flyer($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('promociones_flyer', array('id' => $id));
        return $query->row_array();
    }
    public function edit_flyer($id = FALSE, $nombre = FALSE, $enlace = '', $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($id === FALSE OR $nombre === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'nombre' => $nombre,
            'enlace' => $enlace,
            'url'    => $url,
            'activo' => $activo
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('promociones_flyer', $data);

        return $query;
    }
    public function eliminar_flyer($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        //$this->db->delete('promociones_productos', array('id_promocion' => $id));
        $query = $this->db->delete('promociones_flyer', array('id' => $id));
        return $query;
    }



    public function get_productos_sub($id_subcategoria = FALSE, $activo = FALSE) {
        if ($id_subcategoria === FALSE)
        {
            return FALSE;
        }
        $this->db->select('productos.id AS id,
                           productos.orden AS orden,
                           productos.id_marca AS id_marca,
                           productos.codigo AS codigo,
                           productos.nombre AS nombre,
                           productos.descripcion AS descripcion,
                           productos.imagen AS imagen,
                           productos.thumb AS thumb,
                           productos.url AS url,
                           subcategorias.id AS s_id,
                           marcas.id AS m_id,
                           marcas.marca AS m_marca,
                           marcas.url AS m_url');
        $this->db->from('subcategorias');
        $this->db->join('productos_subcategorias', 'productos_subcategorias.id_subcategoria = subcategorias.id');
        $this->db->join('productos', 'productos.id = productos_subcategorias.id_producto');
        $this->db->join('marcas', 'marcas.id = productos.id_marca');
        $this->db->where('subcategorias.id', $id_subcategoria);
        if($activo) {
            $this->db->where('productos.activo', $activo);
        }
        $this->db->order_by("productos.orden", "asc");


        $query = $this->db->get();
        return $query->result_array();
    }

        public function eliminar_producto($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $ci = get_instance();

        # DESCARGAS
        $descargas = $this->db->get_where('descargas', array('id_producto' => $id));
        $descargas = $descargas->result_array();

        if($descargas) {
            $this->db->delete('descargas', array('id_producto' => $id));
            foreach($descargas as $d) {
                $descarga = "./archivos/".$d['archivo'];
                eliminar_archivo($descarga);
            }
        }

        # INFO
        $info = $this->db->get_where('info', array('id_producto' => $id));
        $info = $info->result_array();

        if($info) {
            $this->db->delete('info', array('id_producto' => $id));
        }

        # SUBCATEGORÃAS
        $this->db->delete('productos_subcategorias', array('id_producto' => $id));

        # PROMOCIONES
        $this->db->delete('promociones_productos', array('id_producto' => $id));

        # GALERÃAS
        $galerias = $this->db->get_where('galerias', array('id_producto' => $id));
        $galerias = $galerias->result_array();

        if($galerias) {
            foreach($galerias as $g) {
                $imagenes = $this->db->get_where('imagenes', array('id_galeria' => $g['id']));
                $imagenes = $imagenes->result_array();

                foreach($imagenes as $i) {
                    $grande = "./img/productos/".$i['grande'];
                    $imagen = "./img/productos/".$i['imagen'];
                    $thumb = "./img/productos/".$i['thumb'];
                    eliminar_archivo($grande);
                    eliminar_archivo($imagen);
                    eliminar_archivo($thumb);
                }
                $this->db->delete('imagenes', array('id_galeria' => $g['id']));
            }
            $this->db->delete('galerias', array('id_producto' => $id));
        }


        $query = $this->db->delete('productos', array('id' => $id));
        return $query;
    }

    public function eliminar_promocion($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->delete('promociones_productos', array('id_promocion' => $id));
        $query = $this->db->delete('promociones', array('id' => $id));
        return $query;
    }

    public function get_promocionid_productos($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('promociones.id AS id,
                           promociones.nombre AS nombre,
                           productos.nombre AS p_nombre,
                           productos.imagen AS p_imagen,
                           productos.thumb AS p_thumb,
                           promociones_productos.id AS pp_id,
                           promociones_productos.id_promocion AS pp_id_promocion,
                           promociones_productos.id_producto AS pp_id_producto');
        $this->db->from('promociones');
        $this->db->join('promociones_productos', 'promociones_productos.id_promocion = promociones.id');
        $this->db->join('productos', 'productos.id = promociones_productos.id_producto');
        $this->db->order_by("promociones_productos.orden", "asc");
        $this->db->where('promociones_productos.id_promocion', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_promociones_productos() {
        $this->db->select('promociones.id AS id,
                           promociones.nombre AS nombre,
                           productos.nombre AS p_nombre,
                           productos.imagen AS p_imagen,
                           productos.thumb AS p_thumb,
                           promociones_productos.id AS pp_id,
                           promociones_productos.id_promocion AS pp_id_promocion,
                           promociones_productos.id_producto AS pp_id_producto');
        $this->db->from('promociones');
        $this->db->join('promociones_productos', 'promociones_productos.id_promocion = promociones.id');
        $this->db->join('productos', 'productos.id = promociones_productos.id_producto');
        $this->db->order_by("promociones_productos.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_promocion_producto($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $this->db->select('promociones_productos.id AS id,
                           promociones_productos.id_promocion AS id_promocion,
                           promociones_productos.id_producto AS id_producto,
                           promociones.id AS promo_id,
                           promociones.nombre AS promo_nombre,
                           productos.id AS p_id,
                           productos.codigo AS p_codigo,
                           productos.nombre AS p_nombre,
                           productos.imagen AS p_imagen,
                           productos.thumb AS p_thumb');
        $this->db->from('promociones');
        $this->db->join('promociones_productos', 'promociones_productos.id_promocion = promociones.id');
        $this->db->join('productos', 'productos.id = promociones_productos.id_producto');
        $this->db->where('promociones_productos.id', $id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function create_promocion_producto($id_promocion = FALSE, $id_producto = FALSE) {
        if ($id_promocion === FALSE OR $id_producto === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM promociones_productos ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_promocion' => $id_promocion,
            'id_producto' => $id_producto
        );

        $data['orden'] = $o;

        $query = $this->db->insert('promociones_productos', $data);
        return $query;
    }

    public function edit_promocion_producto($id = FALSE, $id_promocion = FALSE, $id_producto = FALSE) {
        if ($id === FALSE OR $id_promocion === FALSE OR $id_producto === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'id_promocion' => $id_promocion,
            'id_producto' => $id_producto
        );

        $this->db->where('id', $id);
        $query = $this->db->update('promociones_productos', $data);

        return $query;
    }

    public function eliminar_promocion_producto($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('promociones_productos', array('id' => $id));
        return $query;
    }

    public function get_patrocinadores() {
        $this->db->select('patrocinadores.id AS id,
                           patrocinadores.orden AS orden,
                           patrocinadores.patrocinador AS patrocinador,
                           patrocinadores.imagen AS imagen,
                           patrocinadores.thumb AS thumb');
        $this->db->from('patrocinadores');
        $this->db->order_by("patrocinadores.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_patrocinador($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('patrocinadores', array('id' => $id));
        return $query->row_array();
    }

    public function create_patrocinador($patrocinador = FALSE, $imagen = FALSE, $thumb = FALSE) {
        if ($patrocinador === FALSE OR $imagen === FALSE OR $thumb === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM patrocinadores ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'patrocinador' =>  $patrocinador,
            'imagen' => $imagen,
            'thumb' =>  $thumb
        );

        $data['orden'] = $o;

        $query = $this->db->insert('patrocinadores', $data);
        return $query;
    }

    public function edit_patrocinador($id = FALSE, $patrocinador = FALSE, $imagen = FALSE, $thumb = FALSE) {
        if ($id === FALSE OR $patrocinador === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'patrocinador' => $patrocinador
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('patrocinadores', $data);

        return $query;
    }

    public function eliminar_patrocinador($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('patrocinadores', array('id' => $id));
        return $query;
    }



    public function get_marcas() {
        $this->db->select('marcas.id AS id,
                           marcas.orden AS orden,
                           marcas.marca AS marca,
                           marcas.descripcion AS descripcion,
                           marcas.description AS description,
                           marcas.imagen AS imagen,
                           marcas.thumb AS thumb,
                           marcas.url AS url,
                           marcas.activo AS activo');
        $this->db->from('marcas');
        $this->db->order_by("marcas.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_marca($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('marcas', array('id' => $id));
        return $query->row_array();
    }

    public function create_marca($marca = FALSE, $descripcion = '', $description = '', $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($marca === FALSE OR $imagen === FALSE OR $thumb === FALSE OR $url === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM marcas ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'marca' =>  $marca,
            'descripcion' => $descripcion,
            'description' => $description,
            'imagen' => $imagen,
            'thumb' =>  $thumb,
            'url' =>  $url,
            'activo' =>  $activo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('marcas', $data);
        return $query;
    }

    public function edit_marca($id = FALSE, $marca = FALSE, $descripcion = '', $description = '', $imagen = FALSE, $thumb = FALSE, $url = FALSE, $activo = 1) {
        if ($id === FALSE OR $marca === FALSE OR $url === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'marca' => $marca,
            'descripcion'    => $descripcion,
            'description'    => $description,
            'url'    => $url,
            'activo' =>  $activo
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('marcas', $data);

        return $query;
    }

    public function eliminar_marca($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('marcas', array('id' => $id));
        return $query;
    }

    public function get_banners() {
        $this->db->select('banners.id AS id,
                           banners.orden AS orden,
                           banners.texto AS texto,
                           banners.imagen AS imagen,
                           banners.thumb AS thumb,
                           banners.activo AS activo');
        $this->db->from('banners');
        $this->db->order_by("banners.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_banner($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('banners', array('id' => $id));
        return $query->row_array();
    }

    public function create_banner($texto = '', $texto_2 = '', $imagen = FALSE, $thumb = FALSE, $producto = 0, $activo = 1) {
        if ($imagen === FALSE OR $thumb === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM banners ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'texto' =>  $texto,
            'texto_2' =>  $texto_2,
            'imagen' => $imagen,
            'thumb' =>  $thumb,
            'producto' => $producto,
            'activo' => $activo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('banners', $data);
        return $query;
    }

    public function edit_banner($id = FALSE, $texto = '', $texto_2 = '', $imagen = FALSE, $thumb = FALSE, $producto = 0, $activo = 1) {
        if ($id === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'texto' => $texto,
            'texto_2' =>  $texto_2,
            'producto' => $producto,
            'activo'    => $activo
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('banners', $data);

        return $query;
    }

    public function eliminar_banner($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('banners', array('id' => $id));
        return $query;
    }


    // video -----------------------------------------------------------------------------------
    public function get_videos() {
        $this->db->select('video.id AS id,
                           video.video AS video,
                           video.imagen AS imagen,
                           video.autoplay AS autoplay,
                           video.mute AS mute,
                           video.controls AS controls,
                           video.vloop AS vloop,
                           video.modestbranding AS modestbranding,
                           video.rel AS rel,
                           video.showinfo AS showinfo,
                           video.autohide AS autohide,
                           video.theme AS theme,
                           video.activo AS activo');
        $this->db->from('video');
        $this->db->order_by("video.id", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_video($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('video', array('id' => $id));
        return $query->row_array();
    }

    public function edit_video($id=FALSE, $video = '', $imagen = FALSE, $autoplay = '', $mute = '', $vloop = '', $activo = 1) {
        if ($id === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'video' => $video,
            'autoplay' =>  $autoplay,
            'mute' => $mute,
            'vloop' => $vloop,
            'activo'    => $activo
        );

        if($imagen) {
            $data['imagen'] = $imagen;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('video', $data);

        return $query;
    }

    public function eliminar_video($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('video', array('id' => $id));
        return $query;
    }
    // video -----------------------------------------------------------------------------------




    public function get_categorias($limit = 50, $offset = 0) {
        $this->db->select('categorias.id AS id,
                           categorias.categoria AS categoria,
                           categorias.activo AS activo');
        $this->db->from('categorias');
        $this->db->order_by("categorias.orden", "asc");
        $this->db->limit($limit, $offset);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_todas_categorias() {
        $this->db->select('categorias.id AS id,
                           categorias.categoria AS categoria,
                           categorias.activo AS activo');
        $this->db->from('categorias');
        $this->db->order_by("categorias.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }


    public function get_categoria($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('categorias', array('id' => $id));
        return $query->row_array();
    }

    public function create_categoria($categoria = FALSE, $url = FALSE, $activo = 1) {
        if ($categoria === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM categorias ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'categoria' => $categoria,
            'url' => $url,
            'activo' => $activo
        );

        $data['orden'] = $o;

        $query = $this->db->insert('categorias', $data);
        return $query;
    }

    public function edit_categoria($id = FALSE, $categoria = FALSE, $url = FALSE, $activo = 1) {
        if ($id === FALSE OR $categoria === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'categoria' => $categoria,
            'url'       => $url,
            'activo'    => $activo
        );

        $this->db->where('id', $id);
        $query = $this->db->update('categorias', $data);

        return $query;
    }

    public function eliminar_categoria($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('categorias', array('id' => $id));
        return $query;
    }

    public function get_subcategorias_no_id() {
        $this->db->select('subcategorias.id AS id,
                           subcategorias.id_categoria AS id_categoria,
                           subcategorias.subcategoria AS subcategoria,
                           subcategorias.activo AS activo,
                           subcategorias.thumb AS thumb');
        $this->db->from('subcategorias');
        $this->db->order_by("subcategorias.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_subcategorias($id = FALSE, $limit = 10, $offset = 0) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('subcategorias.id AS id,
                           subcategorias.subcategoria AS subcategoria,
                           subcategorias.activo AS activo,
                           subcategorias.thumb AS thumb');
        $this->db->from('subcategorias');
        $this->db->where('id_categoria', $id);
        $this->db->order_by("subcategorias.orden", "asc");
        $this->db->limit($limit, $offset);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_todas_subcategorias($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }
        $this->db->select('subcategorias.id AS id,
                           subcategorias.subcategoria AS subcategoria,
                           subcategorias.activo AS activo,
                           subcategorias.thumb AS thumb');
        $this->db->from('subcategorias');
        $this->db->where('id_categoria', $id);
        $this->db->order_by("subcategorias.orden", "asc");

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_subcategoria($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->get_where('subcategorias', array('id' => $id));
        return $query->row_array();
    }


    public function create_subcategoria($id_categoria = FALSE, $subcategoria = FALSE, $url = FALSE, $activo = 1, $thumb = FALSE) {
        if ($id_categoria === FALSE OR $subcategoria === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $orden_query ="SELECT orden FROM subcategorias ORDER BY orden DESC LIMIT 1";
        $o = $this->db->query($orden_query);

        if($o->num_rows() > 0) {
            $o_a = $o->result_array();
            $o = $o_a[0]['orden'] + 1;
        } else {
            $o = 1;
        }

        $data = array(
            'id_categoria' => $id_categoria,
            'subcategoria' => $subcategoria,
            'url' => $url,
            'activo' => $activo
        );

        $data['orden'] = $o;

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $query = $this->db->insert('subcategorias', $data);
        return $query;
    }

    public function eliminar_subcategoria($id = FALSE) {
        if ($id === FALSE)
        {
            return FALSE;
        }

        $query = $this->db->delete('subcategorias', array('id' => $id));
        return $query;
    }


    public function edit_subcategoria($id = FALSE, $subcategoria = FALSE, $url = FALSE, $activo = 1, $thumb = FALSE) {
        if ($id === FALSE OR $subcategoria === FALSE OR $url === FALSE OR $activo === FALSE)
        {
            return FALSE;
        }

        $data = array(
            'subcategoria' => $subcategoria,
            'url'       => $url,
            'activo'    => $activo
        );

        if($thumb) {
            $data['thumb'] = $thumb;
        }

        $this->db->where('id', $id);
        $query = $this->db->update('subcategorias', $data);

        return $query;
    }
}