<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

if ( ! function_exists('mostrando'))
{
    function mostrando($total, $pagina, $divisor = 0) {
        $r1 = $divisor + 1;
        $r2 = $divisor +  $pagina;
        $r3 = $total;

        if($r3 == 1) {
            return 'Mostrando ' . number_format($r3) . ' resultado';
        } else if($r3 <= $pagina) {
            return 'Mostrando ' . number_format($r3) . ' resultados';
        } else if($r3 < $r2) {
            return 'Mostrando ' . number_format($r1) . '-' . number_format($r3) . ' de ' . number_format($r3) . ' resultados';
        } else {
            return 'Mostrando ' . number_format($r1) . '-' . number_format($r2) . ' de ' . number_format($r3) . ' resultados';
        }

    }
}

if ( ! function_exists('sustituir_acentos'))
{
    function sustituir_acentos($palabra) {
        $search  = array('Á', 'á', 'É', 'é', 'Í', 'í', 'Ó', 'ó', 'Ú', 'ú', 'Ü', 'ü', 'Ñ', 'ñ');
        $replace = array('A', 'a', 'E', 'e', 'I', 'i', 'O', 'o', 'U', 'u', 'U', 'u', 'N', 'n');
        return str_replace($search, $replace, $palabra);
    }
}

if ( ! function_exists('check_valid_colorhex'))
{
    function check_valid_colorhex($colorCode) {
        // If user accidentally passed along the # sign, strip it off
        $colorCode = ltrim($colorCode, '#');

        if (
            ctype_xdigit($colorCode) &&
            (strlen($colorCode) == 6 || strlen($colorCode) == 3))
            return true;

        else return false;
    }
}

if ( ! function_exists('validar_busqueda'))
{
    function validar_busqueda($q = '') {

        return filter_var($q, FILTER_SANITIZE_STRING);

    }
}

if ( ! function_exists('validar_id'))
{
    function validar_id($id = 0) {
        $id = intval($id);
        $es_numero = is_numeric($id);
        if($es_numero AND $id > 0) {
            return $id;
        } else {
            return FALSE;
        }
    }
}


if ( ! function_exists('eliminar_archivo'))
{
    function eliminar_archivo($full_path) {
        if ($full_path AND file_exists($full_path) AND is_file($full_path)) {
            //    $ch = chmod($full_path, 0777);
            //    if($ch) {
            $ul = unlink($full_path);
            //    }
        }
        if(isset($ul) AND $ul) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
}



if ( ! function_exists('resizeImage'))
{
    function resizeImage($srcFile, $dstWidth, $dstHeight, $dstFile, $formtype = "crop", $jpegQuality = 80)
    {

        if (!file_exists($srcFile)) {
            //  echo "$srcFile no existe! ";
            return false;
        }
        if (!$dstFile) {
            $dstFile = 'tn_' . basename($srcFile);
        }
        if (!is_writable($dstDir = dirname($dstFile))) {
            //  echo "$dstDir no es un directorio con permisos para escribir! ";
            return false;
        }

        list($srcWidth, $srcHeight, $type, ) = getimagesize($srcFile);

        if($formtype == "landscape") {
            $ratio = (double)($srcHeight / $srcWidth);
            $dstHeight = $dstWidth * $ratio;
        } elseif ($formtype == "portrait") {
            $ratio = (double)($srcWidth / $srcHeight);
            $dstWidth = $dstHeight * $ratio;
        }

        switch ($type) {
            case 1 :
                $srcHandle = imagecreatefromgif($srcFile);
                break;
            case 2 :
                $srcHandle = imagecreatefromjpeg($srcFile);
                break;
            case 3 :
                $srcHandle = imagecreatefrompng($srcFile);
                break;
            default :
                //   echo 'Tipo de archivo no soportado! ';
                return false;
        }
        if (!$srcHandle) {
            //  echo 'No es posible ejecutar la funcion imagecreatefrom()';
            return false;
        }

        // Source has a horizontal Shape
        if($srcHeight < $srcWidth AND $formtype == "crop") {
            $ratio = (double)($srcHeight / $dstHeight);
            $cpyWidth = round($dstWidth * $ratio);
            if ($cpyWidth > $srcWidth) {
                $ratio = (double)($srcWidth / $dstWidth);
                $cpyWidth = $srcWidth;
                $cpyHeight = round($dstHeight * $ratio);
                $xOffset = 0;
                $yOffset = round(($srcHeight - $cpyHeight) / 2);
            }
            else {
                $cpyHeight = $srcHeight;
                $xOffset = round(($srcWidth - $cpyWidth) / 2);
                $yOffset = 0;
            }
        }

        // Source has a Vertical Shape
        elseif($srcHeight >= $srcWidth AND $formtype == "crop") {
            $ratio = (double)($srcWidth / $dstWidth);

            $cpyHeight = round($dstHeight * $ratio);
            if ($cpyHeight > $srcHeight) {
                $ratio = (double)($srcHeight / $dstHeight);
                $cpyHeight = $srcHeight;
                $cpyWidth = round($dstWidth * $ratio);
                $xOffset = round(($srcWidth - $cpyWidth) / 2);
                $yOffset = 0;
            }
            else {
                $cpyWidth = $srcWidth;
                $xOffset = 0;
                $yOffset = round(($srcHeight - $cpyHeight) / 2);
            }
        }



        // Source has a horizontal Shape
        if($srcHeight < $srcWidth AND $formtype == "landscape") {
            //  $ratio = (double)($srcHeight / $srcWidth);
            //  $dstHeight = $dstWidth * $ratio;

            $ratio = (double)($srcHeight / $dstHeight);
            $cpyWidth = round($dstWidth * $ratio);
            if ($cpyWidth > $srcWidth) {
                $ratio = (double)($srcWidth / $dstWidth);
                $cpyWidth = $srcWidth;
                $cpyHeight = round($dstHeight * $ratio);
                $xOffset = 0;
                $yOffset = round(($srcHeight - $cpyHeight) / 2);
            }
            else {
                $cpyHeight = $srcHeight;
                $xOffset = round(($srcWidth - $cpyWidth) / 2);
                $yOffset = 0;
            }
        }

        // Source has a Vertical Shape
        elseif($srcHeight >= $srcWidth AND $formtype == "landscape") {
            //   $ratio = (double)($srcHeight / $srcWidth);
            //   $dstHeight = $dstWidth * $ratio;
            /*   echo $ratio;
               echo $dstHeight;
               echo $dstWidth;
               imagedestroy($srcHandle);
               exit(); */

            $ratio = (double)($srcWidth / $dstWidth);

            $cpyHeight = round($dstHeight * $ratio);
            if ($cpyHeight > $srcHeight) {
                $ratio = (double)($srcHeight / $dstHeight);
                $cpyHeight = $srcHeight;
                $cpyWidth = round($dstWidth * $ratio);
                $xOffset = round(($srcWidth - $cpyWidth) / 2);
                $yOffset = 0;
            }
            else {
                $cpyWidth = $srcWidth;
                $xOffset = 0;
                $yOffset = round(($srcHeight - $cpyHeight) / 2);
            }
        }



        // Source has a horizontal Shape
        if($srcHeight < $srcWidth AND $formtype == "portrait") {
            //  $ratio = (double)($srcHeight / $srcWidth);
            //  $dstHeight = $dstWidth * $ratio;

            $ratio = (double)($srcHeight / $dstHeight);
            $cpyWidth = round($dstWidth * $ratio);
            if ($cpyWidth > $srcWidth) {
                $ratio = (double)($srcWidth / $dstWidth);
                $cpyWidth = $srcWidth;
                $cpyHeight = round($dstHeight * $ratio);
                $xOffset = 0;
                $yOffset = round(($srcHeight - $cpyHeight) / 2);
            }
            else {
                $cpyHeight = $srcHeight;
                $xOffset = round(($srcWidth - $cpyWidth) / 2);
                $yOffset = 0;
            }
        }

        // Source has a Vertical Shape
        elseif($srcHeight >= $srcWidth AND $formtype == "portrait") {
            //   $ratio = (double)($srcHeight / $srcWidth);
            //   $dstHeight = $dstWidth * $ratio;
            /*   echo $ratio;
               echo $dstHeight;
               echo $dstWidth;
               imagedestroy($srcHandle);
               exit(); */

            $ratio = (double)($srcWidth / $dstWidth);

            $cpyHeight = round($dstHeight * $ratio);
            if ($cpyHeight > $srcHeight) {
                $ratio = (double)($srcHeight / $dstHeight);
                $cpyHeight = $srcHeight;
                $cpyWidth = round($dstWidth * $ratio);
                $xOffset = round(($srcWidth - $cpyWidth) / 2);
                $yOffset = 0;
            }
            else {
                $cpyWidth = $srcWidth;
                $xOffset = 0;
                $yOffset = round(($srcHeight - $cpyHeight) / 2);
            }
        }


        $dstHandle = imagecreatetruecolor($dstWidth, $dstHeight);


        imagealphablending($dstHandle, false);
        imagesavealpha($dstHandle,true);
        $transparent = imagecolorallocatealpha($dstHandle, 255, 255, 255, 127);
        imagefilledrectangle($dstHandle, 0, 0, $dstWidth, $dstHeight, $transparent);




        // bool imagecopyresampled ( resource dst_image, resource src_image, int dst_x, int dst_y, int src_x, int src_y, int dst_w, int dst_h, int src_w, int src_h )
        if (!imagecopyresampled($dstHandle, $srcHandle, 0, 0, $xOffset, $yOffset, $dstWidth, $dstHeight, $cpyWidth, $cpyHeight)) {
            //  echo 'Could not execute imagecopyresampled() function! ';
            return false;
        }


        imagedestroy($srcHandle);

        switch ($type) {
            case 1 :
                imagegif($dstHandle, $dstFile);
                break;
            case 2 :
                imagejpeg($dstHandle, $dstFile, $jpegQuality);
                break;
            case 3 :
                imagepng($dstHandle, $dstFile);
                break;
            default :
                //  echo 'Tipo de archivo no soportado ';
                return false;
        }

        imagedestroy($dstHandle);

        return true;
    }
}