<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Promo extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index($url = FALSE)
    {
        if($url == FALSE) {
            $red = $this->config->base_url();
            redirect($red, "location");
            return;
        }

        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();
        $data['title'] = "EMS | Promociones";

        $data['promocion'] = $this->site_model->get_promocion($url);


        if($data['promocion']) {
            $data['productos'] = $this->site_model->get_promociones_productos($data['promocion']['id']);
            if($data['productos']) {
                $this->load->view('partials/t_top', $data);
                $this->load->view('partials/t_header', $data);
                $this->load->view('promo/t_promo', $data);
                $this->load->view('partials/t_footer', $data);
                $this->load->view('partials/t_fext2', $data);
                $this->load->view('partials/t_bottom', $data);
                return;
            } else {
                $red = $this->config->base_url();
                redirect($red, "location");
                return;
            }
        } else {
            $red = $this->config->base_url();
            redirect($red, "location");
            return;
        }
        /*
            $q = validar_busqueda(trim($_GET['q']));


            $data['productos'] = $this->site_model->get_productos_buscar($q, TRUE);
            shuffle($data['productos']);
            $data['q'] = $q;

            $this->load->view('partials/top', $data);
            $this->load->view('partials/header', $data);
            $this->load->view('buscar/buscar', $data);
            $this->load->view('partials/footer', $data);
            return;
*/


    }

}

/* End of file Promo.php */
/* Location: ./application/controllers/Promo.php */