<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Producto extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index($id = FALSE, $url = FALSE)
    {
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();
        $data['social'] = $this->load->view('productos/social_int', $data, TRUE);

        $data['producto'] = $this->site_model->get_producto($id);

        if($data['producto']) {
            $data['title'] = "EMS | ".$data['producto']['nombre'];
            $data['thumb'] = $data['producto']['imagen'];

            $data['galerias'] = $this->site_model->get_galerias($data['producto']['id']);
            $data['descargas'] = $this->site_model->get_descargas($data['producto']['id']);
            $data['infos'] = $this->site_model->get_infos($data['producto']['id']);
            $data['productos'] = $this->site_model->get_productos_random(3, TRUE);

            $this->load->view('partials/t_top_producto', $data);
            $this->load->view('partials/t_header', $data);
            $this->load->view('productos/t_producto', $data);
            $this->load->view('partials/t_footer', $data);
            $this->load->view('partials/t_fext3', $data);
            $this->load->view('partials/t_bottom', $data);
        } else {
            show_404();
            return;
        }

    }

}

/* End of file Producto.php */
/* Location: ./application/controllers/Producto.php */