<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class My404 extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index()
    {
        $this->output->set_status_header('404');
        $data['title'] = "EMS | Página no encontrada";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('errors/error_404', $data);
        $this->load->view('partials/t_footer', $data);
        $this->load->view('partials/t_bottom', $data);

    }

}

/* End of file My404.php */
/* Location: ./application/controllers/My404.php */