<?php
    /**
     *
     * @package		CodeIgniter
     * @author		EllisLab Dev Team
     * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
     * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
     * @link		http://codeigniter.com
     * @since		Version 1.0
     * @filesource
     */
    defined('BASEPATH') OR exit('No direct script access allowed');

class Index extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index()
    {
        $data['title'] = "Equipo de Seguridad";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $data['patrocinadores'] = $this->site_model->get_patrocinadores();
        $data['banners'] = $this->site_model->get_banners(TRUE);
        $data['promociones'] = $this->site_model->get_promociones(TRUE);
        $data['promociones_flyer'] = $this->site_model->get_promociones_flyer(TRUE);
        $data['productos'] = $this->site_model->get_productos_number(6, TRUE);
        $data['video'] = $this->site_model->get_video(TRUE);

        $data['social'] = $this->load->view('index/social', $data, TRUE);

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('index/t_index', $data);
        $this->load->view('partials/t_footer', $data);
        $this->load->view('partials/t_fext1', $data);
        $this->load->view('partials/t_bottom', $data);

    }

    public function aviso_de_privacidad()
    {
        $data['title'] = "EMS | Aviso de Privacidad";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('static/t_aviso_de_privacidad', $data);
        $this->load->view('partials/t_footer', $data);

    }

    public function como_comprar()
    {
        $data['title'] = "EMS | Como Comprar";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('static/t_como_comprar', $data);
        $this->load->view('partials/t_footer', $data);

    }

    public function como_cotizar()
    {
        $data['title'] = "EMS | Como Cotizar";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('static/t_como_cotizar', $data);
        $this->load->view('partials/t_footer', $data);

    }

    public function terminos_y_condiciones()
    {
        $data['title'] = "EMS | Terminos y Condiciones";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('static/t_terminos_y_condiciones', $data);
        $this->load->view('partials/t_footer', $data);

    }

    public function contacto()
    {
        $data['title'] = "EMS | Contacto";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->form_validation->set_rules('Name', '"nombre"', 'trim|xss_clean');
        $this->form_validation->set_rules('Company', '"compañía"', 'trim|xss_clean');
        $this->form_validation->set_rules('Tel', '"teléfono"', 'trim|xss_clean');
        $this->form_validation->set_rules('Email', '"email"', 'trim|xss_clean');
        $this->form_validation->set_rules('Message', '"mensaje"', 'trim|xss_clean');
        $this->form_validation->set_rules('captcha', '"captcha"', 'trim|xss_clean');


        if ($this->form_validation->run() == FALSE) {
            $this->load->view('partials/t_top', $data);
            $this->load->view('partials/t_header', $data);
            $this->load->view('static/t_contacto', $data);
            $this->load->view('partials/t_footer', $data);
            return;
        } else {

            $name = $this->input->post('Name');
            $company = $this->input->post('Company');
            $tel = $this->input->post('Tel');
            $email = $this->input->post('Email');
            $message = $this->input->post('Message');
            $captcha = $this->input->post('captcha');

            // if(!name OR !filter_var($email, FILTER_VALIDATE_EMAIL) OR !mensaje OR ($this->session->userdata('cap_code') != $captcha)) {
            //     $red = $this->config->base_url("contacto#error");
            //     redirect($red, "location");
            //     return;
            // }

            $this->load->helper('email');
            $this->load->library('email');

            $config['mailtype'] = 'html';
            $this->email->initialize($config);


            $m_html = '<html><body>Mensaje eviado desde el formulario de contacto de EMS.<br><br>';
            $m_html .= 'Nombre: '.$name.'<br>';
            $m_html .= 'Compañía: '.$company.'<br>';
            $m_html .= 'Teléfono: '.$tel.'<br>';
            $m_html .= 'Email: '.$email.'<br>';
            $m_html .= 'Mensaje: '.$message.'<br>';
            $m_html .= '</body></html>';


            $this->email->from($email, $name);
            $this->email->to('ventas@emsmex.com');
            $this->email->subject("Mensaje de EMS");
            $this->email->message($m_html);


            if($this->email->send()) {
                $red = $this->config->base_url("gracias");
                redirect($red, "location");
                return;

            } else {
                $this->load->view('partials/top', $data);
                $this->load->view('partials/header', $data);
                $this->load->view('static/contacto', $data);
                $this->load->view('partials/footer', $data);
                return;
            }


        }



    }

    public function captcha() {

        $ranStr = md5(microtime());
        $ranStr = substr($ranStr, 0, 6);

        $this->session->set_userdata('cap_code', $ranStr);

        $newImage = imagecreatefromjpeg(base_url("files/captcha/cap_bg.jpg"));
        $txtColor = imagecolorallocate($newImage, 0, 0, 0);
        imagestring($newImage, 5, 5, 5, $ranStr, $txtColor);
        header("Content-type: image/jpeg");
        imagejpeg($newImage);
        return;

    }

    public function _404()
    {
        $data['title'] = "EMS | Página no encontrada";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/top', $data);
        $this->load->view('partials/header', $data);
        $this->load->view('errors/error_404', $data);
        $this->load->view('partials/footer', $data);

    }

    public function gracias()
    {
        $data['title'] = "EMS | Gracias";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('static/gracias', $data);
        $this->load->view('partials/t_footer', $data);

    }

}

/* End of file Index.php */
/* Location: ./application/controllers/Index.php */