<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Empresa extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index()
    {
        $data['title'] = "EMS | Empresa";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $data['marcas'] = $this->site_model->get_marcas(TRUE);

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('empresa/t_empresa', $data);
        $this->load->view('partials/t_footer', $data);

    }

    public function english()
    {
        $data['title'] = "EMS | Company";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $data['marcas'] = $this->site_model->get_marcas(TRUE);

        $this->load->view('partials/t_top', $data);
        $this->load->view('partials/t_header', $data);
        $this->load->view('empresa/t_empresa_e', $data);
        $this->load->view('partials/t_footer', $data);

    }

}

/* End of file Empresa.php */
/* Location: ./application/controllers/Empresa.php */