<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Categorias extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index($categoria = FALSE)
    {
        $data['title'] = "EMS | Empresa";
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $data['marcas'] = $this->site_model->get_marcas();

        $this->load->view('partials/top', $data);
        $this->load->view('partials/header', $data);
        $this->load->view('empresa/empresa', $data);
        $this->load->view('partials/footer', $data);

    }

    public function subcategoria($categoria = FALSE, $subcategoria = FALSE)
    {
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();

        $data['categoria'] = $this->site_model->get_categoria(FALSE, $categoria, TRUE);

        if($data['categoria']) {
            $data['subcategoria'] = $this->site_model->get_subcategoria(FALSE, $data['categoria']['id'], $subcategoria, TRUE);
            if($data['subcategoria']) {
                $data['productos'] = $this->site_model->get_productos($data['subcategoria']['id'], TRUE);

                $data['title'] = $data['categoria']['categoria']." - ".$data['subcategoria']['subcategoria'];

                $this->load->view('partials/t_top', $data);
                $this->load->view('partials/t_header', $data);
                $this->load->view('categorias/t_subcategoria', $data);
                $this->load->view('partials/t_footer', $data);
                $this->load->view('partials/t_fext2', $data);
                $this->load->view('partials/t_bottom', $data);
            } else {
                show_404();
                return;
            }
        } else {
            show_404();
            return;
        }

    }

}

/* End of file Categorias.php */
/* Location: ./application/controllers/Categorias.php */