<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Buscar extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('site_model');
        $this->load->helper('custom_helper');
    }


    public function index()
    {
        $data['categorias'] = $this->site_model->get_categorias_activas();
        $data['subcategorias'] = $this->site_model->get_subcategorias_activas();
        $data['title'] = "EMS | Búsqueda";

        if(isset($_GET['q'])) {
            $q = validar_busqueda(trim($_GET['q']));


            $data['productos'] = $this->site_model->get_productos_buscar($q, TRUE);
            shuffle($data['productos']);
            $data['q'] = $q;

            $this->load->view('partials/t_top', $data);
            $this->load->view('partials/t_header', $data);
            $this->load->view('buscar/t_buscar', $data);
            $this->load->view('partials/t_footer', $data);
            $this->load->view('partials/t_fext2', $data);
            $this->load->view('partials/t_bottom', $data);
            return;
        }






            // $q = filter_var($q, FILTER_SANITIZE_STRING);

        //$this->load->view('partials/top', $data);
        /*

        $data['producto'] = $this->site_model->get_producto($id);

        if($data['producto']) {
            $data['title'] = "EMS | ".$data['producto']['nombre'];

            $data['galerias'] = $this->site_model->get_galerias($data['producto']['id']);
            $data['descargas'] = $this->site_model->get_descargas($data['producto']['id']);
            $data['infos'] = $this->site_model->get_infos($data['producto']['id']);
            $data['productos'] = $this->site_model->get_productos_random(3, TRUE);

            $this->load->view('partials/top', $data);
            $this->load->view('partials/header', $data);
            $this->load->view('productos/producto', $data);
            $this->load->view('partials/footer', $data);
        } else {
            show_404();
            return;
        }
        */

    }

}

/* End of file Buscar.php */
/* Location: ./application/controllers/Buscar.php */