<?php
/**
 *
 * @package		CodeIgniter
 * @author		EllisLab Dev Team
 * @copyright	Copyright (c) 2008 - 2014, EllisLab, Inc. (http://ellislab.com/)
 * @license		http://opensource.org/licenses/AFL-3.0 Academic Free License (AFL 3.0)
 * @link		http://codeigniter.com
 * @since		Version 1.0
 * @filesource
 */
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

    public $admin = 'admin';

    public function __construct()
    {
        parent::__construct();
        //$this->load->database();
        $this->load->helper('form');
        $this->load->library('form_validation');
        $this->load->library('pagination');
        $this->load->model('admin_model');
        $this->load->helper('custom_helper');
    }


    public function index()
    {

        if($this->session->userdata('estatus') == 'admin') {
            $dir = $this->admin."/categorias";
            redirect($dir, "location");
            return;
        }

        $this->form_validation->set_rules('usuario', '"usuario"', 'required');
        $this->form_validation->set_rules('password', '"contraseña"', 'callback_login_check');


        if ($this->form_validation->run() == FALSE) {
            $this->load->view('admin/top');
            $this->load->view('admin/index');
            //$this->load->view('admin/bottom');
            return;
        } else {

            $username = $this->input->post('usuario');
            $password = $this->input->post('password');

            if($username == 'admin' AND $password == 'tact201') {
                $this->session->set_userdata('estatus', 'admin');

                $dir = $this->admin."/productos";
                redirect($dir, "location");
                return;

            } else {
                $this->form_validation->set_message('login_check', 'La información introducida no es correcta.');
                return FALSE;
            }

        }



    }



    public function login_check($str) {
        $username = $this->input->post('usuario');
        $password = $this->input->post('password');

        if($username == 'admin' AND $password == 'tact201') {
            return TRUE;
        } else {
            $this->form_validation->set_message('login_check', 'La información introducida no es correcta.');
            return FALSE;
        }

    }


    public function salir() {
        $this->session->sess_destroy();
        redirect($this->admin, 'location');
        return;
    }

    public function imagenes_eliminar($id_galeria = FALSE, $id_imagen = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        $id_galeria = validar_id($id_galeria);
        $id_imagen = validar_id($id_imagen);

        if($id_galeria AND $id_imagen) {
            $imagen = $this->admin_model->get_imagen($id_imagen);
            $eliminar_imagen = $this->admin_model->eliminar_imagen($id_imagen, $id_galeria);

            if($imagen AND $eliminar_imagen) {

                $old_path_gnd = "./img/productos/".$imagen['grande'];
                $old_path_img = "./img/productos/".$imagen['imagen'];
                $old_path_thumb = "./img/productos/".$imagen['thumb'];

                eliminar_archivo($old_path_gnd);
                eliminar_archivo($old_path_img);
                eliminar_archivo($old_path_thumb);

                $red = $this->config->base_url($this->admin."/galerias/imagenes/".$id_galeria);
                redirect($red, "location");
                return;

            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }
        } else {
            $red = $this->config->base_url($this->admin."/productos");
            redirect($red, "location");
            return;
        }
    }

    public function info_eliminar($id_producto = FALSE, $id_info = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        $id_producto = validar_id($id_producto);
        $id_info = validar_id($id_info);

        if($id_producto AND $id_info) {
            $info = $this->admin_model->get_info($id_info);
            $eliminar_info = $this->admin_model->eliminar_info($id_info, $id_producto);

            if($info AND $eliminar_info) {

                $red = $this->config->base_url($this->admin."/productos/info/".$id_producto);
                redirect($red, "location");
                return;

            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }
        } else {
            $red = $this->config->base_url($this->admin."/productos");
            redirect($red, "location");
            return;
        }
    }

    public function descargas_eliminar($id_producto = FALSE, $id_descarga = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        $id_producto = validar_id($id_producto);
        $id_descarga = validar_id($id_descarga);

        if($id_producto AND $id_descarga) {
            $descarga = $this->admin_model->get_descarga($id_descarga);
            $eliminar_descarga = $this->admin_model->eliminar_descarga($id_descarga, $id_producto);

            if($descarga AND $eliminar_descarga) {

                $old_path_img = "./archivos/".$descarga['archivo'];
                //$old_path_thumb = "./img/productos/".$imagen['thumb'];

                eliminar_archivo($old_path_img);
                //eliminar_archivo($old_path_thumb);

                $red = $this->config->base_url($this->admin."/productos/descargas/".$id_producto);
                redirect($red, "location");
                return;

            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }
        } else {
            $red = $this->config->base_url($this->admin."/productos");
            redirect($red, "location");
            return;
        }
    }

    public function galerias($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        if($pag == "agregar") {
            $id = validar_id($id);
            //$data['productos'] = $this->admin_model->get_productos();

            $data['seccion1']= "productos";
            $data['seccion2']= "agregar";

            if($id) {
                $producto = $this->admin_model->get_producto($id);
                $data['id_galerias'] = $id;
            }

            if($id AND $producto) {


                $this->form_validation->set_rules('color', '"color"', 'trim|required|min_length[7]|max_length[7]|xss_clean');
                $this->form_validation->set_rules('send', '"botón"', 'required');



                if ($this->form_validation->run() == FALSE) {
                    $data['producto'] = $producto;

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/galerias_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                } else {
                    //$subcategoria = $this->input->post('subcategoria');
                    //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                    $color = $this->input->post('color');



                    if(check_valid_colorhex($color)) {
                        $add_galeria = $this->admin_model->create_galeria($id, $color);
                    } else {
                        $data['error_imagen'] = "Por favor selecciona un color utilizando la herramienta o escribiendo un valor válido en el campo del color.";
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_agregar', $data);
                        return;
                    }

                    if(isset($add_galeria) AND $add_galeria) {
                        $red = $this->config->base_url($this->admin."/galerias/".$id);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_agregar', $data);
                        //$this->load->view('admin/footer', $data);
                        retutn;
                    }

                }

            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }

        } else if($pag == "editar") {
            $data['seccion1']= "productos";
            $data['seccion2']= "editar";

            if($id) {

                $data['galeria_info'] = $this->admin_model->get_galeria($id);
                $data['id_galerias'] = $data['galeria_info']['id_producto'];

                $this->form_validation->set_rules('color', '"color"', 'trim|required|min_length[7]|max_length[7]|xss_clean');
                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    if($data['galeria_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    }

                } else {
                    $color = $this->input->post('color');

                    if(check_valid_colorhex($color)) {
                        $edit_galeria = $this->admin_model->edit_galeria($id, $color);
                    } else {
                        $edit_galeria = FALSE;
                        $data['error_imagen'] = "Por favor selecciona un color utilizando la herramienta o escribiendo un valor válido en el campo del color.";
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_editar', $data);
                        return;
                    }

                    if($edit_galeria) {
                        $red = $this->config->base_url($this->admin."/galerias/".$data['id_galerias']);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }

            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }

        } else if($pag == "imagenes") {
            $data['seccion1']= "productos";
            $data['seccion2']= "imagenes";

            if($id) {
                $data['galeria_info'] = $this->admin_model->get_galeria($id);
                $data['id_galerias'] = $data['galeria_info']['id_producto'];
                $data['l_imagenes'] = $this->admin_model->get_imagenes($id);

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    if($data['galeria_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_imagenes', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $configup['upload_path'] = './img/productos/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();


                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/galerias_imagenes', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/galerias_imagenes', $data);
                            return;
                        }



                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_gnd = $uniqid.'_gnd'.$data['upload_data']['file_ext'];
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                        $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                        $path_gnd = './img/productos/'.$nm_gnd;
                        $path_grande = './img/productos/'.$nm_grande;
                        $path_thumb = './img/productos/'.$nm_thumb;

                        resizeImage($original, 1200, 1200, $path_gnd, "crop", 90);
                        resizeImage($original, 500, 500, $path_grande, "crop", 90);
                        resizeImage($original, 150, 136, $path_thumb, "crop", 90);

                        //      $imagen = $nm_grande;

                        eliminar_archivo($original);

                        $add_imagen = $this->admin_model->create_imagen($id, $nm_gnd, $nm_grande, $nm_thumb);

                    } else if($_FILES['imagen']['error'] == 4) {
                        $add_imagen = FALSE;
                        $data['error_imagen'] = 'No has seleccionado una imagen para subir.';

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_imagenes', $data);
                        return;

                    } else if($_FILES['imagen']['error'] == 1 OR $_FILES['imagen']['error'] == 2) {
                        $add_imagen = FALSE;
                        $data['error_imagen'] = 'Por favor, agrega una imagen menor a los 5 megas.';

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_imagenes', $data);
                        return;
                    } else {
                        $add_imagen = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_imagenes', $data);
                        return;
                    }

                    if($add_imagen) {
                        $red = $this->config->base_url($this->admin."/galerias/imagenes/".$id);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_imagenes', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }
                }
            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }

        } else if($pag == "eliminar") {
            $data['seccion1']= "productos";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['galeria_info'] = $this->admin_model->get_galeria($id);
                $data['id_galerias'] = $data['galeria_info']['id_producto'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['galeria_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_galeria = $this->admin_model->eliminar_galeria($id);

                    if($eliminar_galeria) {
                        $red = $this->config->base_url($this->admin."/galerias/".$data['id_galerias']);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/galerias_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }

        }  else if($pag == "ordenar") {

            $data['seccion1']= "productos";
            $data['seccion2']= "ordenar";

            if($id) {

                $producto = $this->admin_model->get_producto($id);
                $data['id_galerias'] = $id;

            }

            if($id AND $producto) {

                $data['l_galerias'] = $this->admin_model->get_galerias($id);

                $this->load->view('admin/header', $data);
                $this->load->view('admin/galerias_ordenar', $data);
                return;
            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }

        } else {
            $pag = validar_id($pag);

            if($pag) {

                $data['producto_info'] = $this->admin_model->get_producto($pag);

                $data['lista_galerias'] = $this->admin_model->get_galerias($pag);

                $data['resultados'] = mostrando(count($data['lista_galerias']), 1000);

                $data['seccion1']= "productos";
                $data['seccion2']= "lista";
                $data['id_galerias'] = $pag;
                $this->load->view('admin/header', $data);
                $this->load->view('admin/galerias_lista', $data);
                //$this->load->view('admin/footer', $data);
                return;


            } else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }
        }



    }


    public function promociones($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "promociones";
            $data['seccion2']= "agregar";

            $data['productos'] = $this->admin_model->get_productos();

            $this->form_validation->set_rules('nombre', '"nombre"', 'trim|max_length[300]|xss_clean');
            //$this->form_validation->set_rules('descripcion', '"descripción"', 'trim|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/promociones_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                $nombre = $this->input->post('nombre');
                //$descripcion = $this->input->post('descripcion');
                //$producto_1 = $this->input->post('hq1');
                //$producto_2 = $this->input->post('hq2');
                $url = url_title(strtolower(sustituir_acentos($nombre)));
                $activo = $this->input->post('activo');

                //var_dump($_FILES);
                //return;


                $configup['upload_path'] = './img/promociones/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);

                if($_FILES['imagen']['error'] == 0 AND $_FILES['imagenp']['error'] == 0) {
                    if($_FILES['imagen']['error'] == 0) {
                        $img = "imagen";
                         if($this->upload->do_upload($img)) {
                            $data['upload_data'] = $this->upload->data();

                            if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {
                                $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                                $this->load->view('admin/header', $data);
                                $this->load->view('admin/promociones_agregar', $data);
                                return;
                            }

                            if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                                $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                                $this->load->view('admin/header', $data);
                                $this->load->view('admin/promociones_agregar', $data);
                                return;
                            }

                            $original = $data['upload_data']['full_path'];
                            $uniqid = uniqid();
                            $nm_grande = $uniqid.'_f'.$data['upload_data']['file_ext'];
                            $nm_thumb = $uniqid.'_fthumb'.$data['upload_data']['file_ext'];

                            $path_grande = './img/promociones/'.$nm_grande;
                            $path_thumb = './img/promociones/'.$nm_thumb;

                            resizeImage($original, 700, 400, $path_grande, "crop", 90);
                            resizeImage($original, 150, 86, $path_thumb, "crop", 90);

                            eliminar_archivo($original);

                         }
                    }

                    if($_FILES['imagenp']['error'] == 0) {
                        $img = "imagenp";
                         if($this->upload->do_upload($img)) {
                            $data['upload_data'] = $this->upload->data();

                            if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {
                                $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                                $this->load->view('admin/header', $data);
                                $this->load->view('admin/promociones_agregar', $data);
                                return;
                            }

                            if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                                $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                                $this->load->view('admin/header', $data);
                                $this->load->view('admin/promociones_agregar', $data);
                                return;
                            }

                            $originalp = $data['upload_data']['full_path'];
                            $uniqid = uniqid();
                            $nmp_grande = $uniqid.'_p'.$data['upload_data']['file_ext'];
                            $nmp_thumb = $uniqid.'_pthumb'.$data['upload_data']['file_ext'];

                            $pathp_grande = './img/promociones/'.$nmp_grande;
                            $pathp_thumb = './img/promociones/'.$nmp_thumb;

                            resizeImage($originalp, 327, 107, $pathp_grande, "crop", 90);
                            resizeImage($originalp, 150, 49, $pathp_thumb, "crop", 90);

                            eliminar_archivo($originalp);

                         }
                    }

                    $add_promocion = $this->admin_model->create_promocion($nombre, $nmp_grande, $nmp_thumb, $nm_grande, $nm_thumb, $url, $activo);

                } else if($_FILES['imagen']['error'] == 4 OR $_FILES['imagenp']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega las imágenes correspondientes.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = 'No fue posible añadir las imágenes, por favor vuelve a intentarlo en un momento.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_agregar', $data);
                    return;
                }

                if($add_promocion) {
                    $red = $this->config->base_url($this->admin."/promociones");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

                /*
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/promociones/'.$nm_grande;
                    $path_thumb = './img/promociones/'.$nm_thumb;

                    resizeImage($original, 700, 400, $path_grande, "crop", 90);
                    resizeImage($original, 150, 86, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    //$add_promocion = $this->admin_model->create_promocion($nombre, $descripcion, $producto_1, $producto_2, $nm_grande, $nm_thumb, $url, $activo);
                    $add_promocion = $this->admin_model->create_promocion($nombre, $nm_grande, $nm_thumb, $url, $activo);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_agregar', $data);
                    return;
                }

                if($add_promocion) {
                    $red = $this->config->base_url($this->admin."/promociones");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }
*/
            }

        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "promociones";
            $data['seccion2']= "editar";

            if($id) {

                $data['promo_info'] = $this->admin_model->get_promocion($id);
                $data['productos'] = $this->admin_model->get_productos();

                /*
                if($data['promo_info']['producto_1']) {
                    $data['producto_1'] = $this->admin_model->get_producto($data['promo_info']['producto_1']);
                } else {
                    $data['producto_1'] = FALSE;
                }

                if($data['promo_info']['producto_2']) {
                    $data['producto_2'] = $this->admin_model->get_producto($data['promo_info']['producto_2']);
                } else {
                    $data['producto_2'] = FALSE;
                }
                */

                $this->form_validation->set_rules('nombre', '"nombre"', 'trim|max_length[300]|xss_clean');
                //$this->form_validation->set_rules('descripcion', '"descripción"', 'trim|xss_clean');

                if ($this->form_validation->run() == FALSE) {

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;

                } else {
                    $delete_image = FALSE;
                    $nombre = $this->input->post('nombre');
                    //$descripcion = $this->input->post('descripcion');
                    //$producto_1 = $this->input->post('hq1');;
                    //$producto_2 = $this->input->post('hq2');
                    $url = url_title(strtolower(sustituir_acentos($nombre)));
                    $activo = $this->input->post('activo');


                    $configup['upload_path'] = './img/promociones/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);

                    $cp_img = FALSE;
                    $c_img = false;

                    if($_FILES['imagen']['error'] == 0 OR $_FILES['imagenp']['error'] == 0) {
                        if($_FILES['imagen']['error'] == 0) {
                            $img = "imagen";
                             if($this->upload->do_upload($img)) {
                                $data['upload_data'] = $this->upload->data();

                                if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {
                                    $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                                    $this->load->view('admin/header', $data);
                                    $this->load->view('admin/promociones_agregar', $data);
                                    return;
                                }

                                if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                                    $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                                    $this->load->view('admin/header', $data);
                                    $this->load->view('admin/promociones_agregar', $data);
                                    return;
                                }

                                $original = $data['upload_data']['full_path'];
                                $uniqid = uniqid();
                                $nm_grande = $uniqid.'_f'.$data['upload_data']['file_ext'];
                                $nm_thumb = $uniqid.'_fthumb'.$data['upload_data']['file_ext'];

                                $path_grande = './img/promociones/'.$nm_grande;
                                $path_thumb = './img/promociones/'.$nm_thumb;

                                resizeImage($original, 700, 400, $path_grande, "crop", 90);
                                resizeImage($original, 150, 86, $path_thumb, "crop", 90);

                                eliminar_archivo($original);

                                $c_img = TRUE;



                             }
                        } else {
                            $nm_grande = FALSE;
                            $nm_thumb = FALSE;
                        }

                        if($_FILES['imagenp']['error'] == 0) {
                            $img = "imagenp";
                             if($this->upload->do_upload($img)) {
                                $data['upload_data'] = $this->upload->data();

                                if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {
                                    $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                                    $this->load->view('admin/header', $data);
                                    $this->load->view('admin/promociones_agregar', $data);
                                    return;
                                }

                                if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                                    $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                                    $this->load->view('admin/header', $data);
                                    $this->load->view('admin/promociones_agregar', $data);
                                    return;
                                }

                                $originalp = $data['upload_data']['full_path'];
                                $uniqid = uniqid();
                                $nmp_grande = $uniqid.'_f'.$data['upload_data']['file_ext'];
                                $nmp_thumb = $uniqid.'_fthumb'.$data['upload_data']['file_ext'];

                                $pathp_grande = './img/promociones/'.$nmp_grande;
                                $pathp_thumb = './img/promociones/'.$nmp_thumb;

                                resizeImage($originalp, 327, 107, $pathp_grande, "crop", 90);
                                resizeImage($originalp, 150, 49, $pathp_thumb, "crop", 90);

                                eliminar_archivo($originalp);

                                $cp_img = TRUE;



                             }
                        } else {
                            $nmp_grande = FALSE;
                            $nmp_thumb = FALSE;
                        }

                        $edit_promocion = $this->admin_model->edit_promocion($id, $nombre, $nmp_grande, $nmp_thumb, $nm_grande, $nm_thumb, $url, $activo);


                    } else if($_FILES['imagen']['error'] == 4 AND $_FILES['imagen']['error'] == 4) {

                        $edit_promocion = $this->admin_model->edit_promocion($id, $nombre, FALSE, FALSE, FALSE, FALSE, $url, $activo);

                    } else {
                        $edit_promocion = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_editar', $data);
                        return;
                    }


                    if($edit_promocion) {
                            if($c_img) {
                                if($nm_grande AND $nm_thumb AND file_exists($path_grande) AND file_exists($path_thumb)) {
                                    $d_imagen = './img/promociones/'.$data['promo_info']['imagen'];
                                    $d_thumb = './img/promociones/'.$data['promo_info']['thumb'];

                                    if(file_exists($d_imagen)){eliminar_archivo($d_imagen);}
                                    if(file_exists($d_thumb)){eliminar_archivo($d_thumb);}
                                }
                            }

                            if($cp_img) {
                                if($nmp_grande AND $nmp_thumb AND file_exists($pathp_grande) AND file_exists($pathp_thumb)) {
                                    $dp_imagen = './img/promociones/'.$data['promo_info']['imagenp'];
                                    $dp_thumb = './img/promociones/'.$data['promo_info']['thumbp'];

                                    if(file_exists($dp_imagen)){eliminar_archivo($dp_imagen);}
                                    if(file_exists($dp_thumb)){eliminar_archivo($dp_thumb);}
                                }
                            }
                            $red = $this->config->base_url($this->admin."/promociones");
                            redirect($red, "location");
                            return;
                        } else {
                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/promociones_editar', $data);
                            //$this->load->view('admin/footer', $data);
                            return;
                        }










                /*

                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();


                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/promociones_editar', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/promociones_editar', $data);
                            return;
                        }



                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                        $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                        $path_grande = './img/promociones/'.$nm_grande;
                        $path_thumb = './img/promociones/'.$nm_thumb;

                        resizeImage($original, 418, 302, $path_grande, "crop", 90);
                        resizeImage($original, 150, 108, $path_thumb, "crop", 90);

                        //      $imagen = $nm_grande;

                        eliminar_archivo($original);

                        $edit_promocion = $this->admin_model->edit_promocion($id, $nombre, $descripcion, $producto_1, $producto_2, $nm_grande, $nm_thumb, $url, $activo);
                        $delete_image = TRUE;

                    } else if($_FILES['imagen']['error'] == 4) {

                        $edit_promocion = $this->admin_model->edit_promocion($id, $nombre, $descripcion, $producto_1, $producto_2, FALSE, FALSE, $url, $activo);

                    } else {
                        $edit_promocion = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_editar', $data);
                        return;
                    }

                    if($edit_promocion) {
                        if($delete_image) {
                            $old_path = "./img/promociones/".$data['promo_info']['thumb'];
                            eliminar_archivo($old_path);
                        }
                        $red = $this->config->base_url($this->admin."/promociones");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }
*/
                }
            } else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }


        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "promociones";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['promo_info'] = $this->admin_model->get_promocion($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['promo_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/promociones");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_promocion = $this->admin_model->eliminar_promocion($id);

                    if($eliminar_promocion) {

                        $old_path_img = "./img/promociones/".$data['promo_info']['imagen'];
                        $old_path_thumb = "./img/promociones/".$data['promo_info']['thumb'];

                        if(file_exists($old_path_img) AND file_exists($old_path_thumb)) {
                            eliminar_archivo($old_path_img);
                            eliminar_archivo($old_path_thumb);
                        }

                        $old_path_imgp = "./img/promociones/".$data['promo_info']['imagenp'];
                        $old_path_thumbp = "./img/promociones/".$data['promo_info']['thumbp'];

                        if(file_exists($old_path_imgp) AND file_exists($old_path_thumbp)) {
                            eliminar_archivo($old_path_imgp);
                            eliminar_archivo($old_path_thumbp);
                        }

                        //$old_path_img = "./img/promociones/".$data['promo_info']['imagen'];
                        //$old_path_thumb = "./img/promociones/".$data['promo_info']['thumb'];

                        //eliminar_archivo($old_path_img);
                        //eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/promociones");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "promociones";
            $data['seccion2']= "ordenar";

            $data['l_promociones'] = $this->admin_model->get_promociones();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/promociones_ordenar', $data);
            return;

        } else {

            $data['lista_promociones'] = $this->admin_model->get_promociones();

            $data['resultados'] = mostrando(count($data['lista_promociones']), 1000);

            $data['seccion1']= "promociones";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/promociones_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }

    public function promociones_productos($pag = FALSE, $id = FALSE) {

        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        if($pag == "agregar") {

            $id = validar_id($id);
            $data['productos'] = $this->admin_model->get_productos();

            $data['seccion1']= "promociones";
            $data['seccion2']= "agregar";

            if($id) {
                $promo = $this->admin_model->get_promocion($id);
                $data['id_promociones_productos'] = $id;
            }


            if($id AND $promo) {


                //$this->form_validation->set_rules('subcategoria', '"subcategoria"', 'trim|required|min_length[3]|max_length[40]|xss_clean');
                $this->form_validation->set_rules('send', '"botón"', 'required');



                if ($this->form_validation->run() == FALSE) {
                    $data['promo'] = $promo;

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_productos_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                } else {

                    //echo $this->input->post('q');
                    //return;
                    //$subcategoria = $this->input->post('subcategoria');
                    //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                    $producto = $this->input->post('hq');

                        $exist = $this->admin_model->get_producto($producto);

                    if($exist AND is_numeric($producto) AND $producto > 0) {
                        $add_promo = $this->admin_model->create_promocion_producto($id, $producto);
                    } else {
                        $data['error_imagen'] = "Por favor selecciona un producto de la lista desplegable.";
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_agregar', $data);
                        return;
                    }

                    if(isset($add_promo) AND $add_promo) {
                        $red = $this->config->base_url($this->admin."/promociones_productos/".$id);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_agregar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }

            } else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }


        } else if($pag == "editar") {
            $data['seccion1']= "promociones";
            $data['seccion2']= "editar";

            if($id) {

                $data['promo_info'] = $this->admin_model->get_promocion_producto($id);
                $data['productos'] = $this->admin_model->get_productos();
                $data['id_promociones_productos'] = $data['promo_info']['id_promocion'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {



                    if($data['promo_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/promociones");
                        redirect($red, "location");
                        return;
                    }

                } else {
                    $producto = $this->input->post('hq');

                    $exist = $this->admin_model->get_producto($producto);

                    if($exist AND is_numeric($producto) AND $producto > 0) {
                        $edit_promo = $this->admin_model->edit_promocion_producto($id, $data['id_promociones_productos'], $producto);
                    } else {
                        $edit_promo = FALSE;
                        $data['error_imagen'] = "Por favor selecciona un producto de la lista desplegable.";
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_editar', $data);
                        return;
                    }

                    if($edit_promo) {
                        $red = $this->config->base_url($this->admin."/promociones-productos/".$data['id_promociones_productos']);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }

            } else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }


        } else if($pag == "eliminar") {
            $data['seccion1']= "promociones";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['promo_info'] = $this->admin_model->get_promocion_producto($id);
                $data['id_promociones_productos'] = $data['promo_info']['id_promocion'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['promo_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/promociones");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_promo = $this->admin_model->eliminar_promocion_producto($id);

                    if($eliminar_promo) {
                        $red = $this->config->base_url($this->admin."/promociones-productos/".$data['id_promociones_productos']);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_productos_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }

        } else if($pag == "ordenar") {

            $data['seccion1']= "promociones";
            $data['seccion2']= "ordenar";

            if($id) {

                $promo = $this->admin_model->get_promocion($id);
                $data['id_promociones_productos'] = $id;

            }

            if($id AND $promo) {

                $data['l_promociones_productos'] = $this->admin_model->get_promociones_productos($id);

                $this->load->view('admin/header', $data);
                $this->load->view('admin/promociones_productos_ordenar', $data);
                return;
            } else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }



        } else {

            $pag = validar_id($pag);

            if($pag) {

                $data['promo_info'] = $this->admin_model->get_promocion($pag);

                $data['lista_promociones_productos'] = $this->admin_model->get_promocionid_productos($pag);

                $data['resultados'] = mostrando(count($data['lista_promociones_productos']), 1000);

                $data['seccion1']= "promociones";
                $data['seccion2']= "lista";
                $data['id_promociones_productos'] = $pag;
                $this->load->view('admin/header', $data);
                $this->load->view('admin/promociones_productos_lista', $data);
                //$this->load->view('admin/footer', $data);
                return;


            } else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }
        }

    }


    public function productos($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "productos";
            $data['seccion2']= "agregar";

            $data['categorias'] = $this->admin_model->get_categorias();
            $data['subcategorias'] = $this->admin_model->get_subcategorias_no_id();

            $data['marcas'] = $this->admin_model->get_marcas();

            //$this->form_validation->set_rules('texto', '"texto"', 'trim|max_length[300]|xss_clean');
            $this->form_validation->set_rules('nombre', '"nombre"', 'trim|required|min_length[2]|is_unique[marcas.marca]|max_length[255]|xss_clean');
            $this->form_validation->set_rules('codigo', '"codigo"', 'trim|max_length[50]|xss_clean');

            //$this->form_validation->set_rules('categoria', '"categoría"', 'is_natural_no_zero');
            $this->form_validation->set_message('is_natural_no_zero', 'Por favor, selecciona una %s');

            $this->form_validation->set_rules('marca', '"marca"', 'is_natural_no_zero');
            $this->form_validation->set_message('is_natural_no_zero', 'Por favor, selecciona una %s');

            $this->form_validation->set_rules('descripcion', '"descripción"', 'trim|xss_clean');

            $this->form_validation->set_rules('precio', '"precio"', 'trim|is_natural|xss_clean');
            $this->form_validation->set_rules('tallas', '"tallas"', 'trim|xss_clean');
            $this->form_validation->set_rules('tags', '"etiquetas"', 'trim|xss_clean');
            $this->form_validation->set_rules('video', '"video"', 'trim|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/productos_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                //$texto = $this->input->post('texto');
                $activo = $this->input->post('activo');
                $categoria = array_unique($this->input->post('categoria'));

                /*
                if(($key = array_search(0, $categoria)) !== false) {
                    unset($categoria[$key]);
                }

                foreach (array_keys($categoria, 0, true) as $key) {
                    unset($categoria[$key]);
                } */

                $categoria = array_filter($categoria);

                if(count($categoria) < 1 OR $categoria == 0) {
                    $data['error_imagen'] = 'Por favor, selecciona una categoría.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/productos_agregar', $data);
                    return;
                }

                $marca = $this->input->post('marca');
                $nombre = $this->input->post('nombre');
                $codigo = $this->input->post('codigo');
                $descripcion = $this->input->post('descripcion');
                $url = url_title(strtolower(sustituir_acentos($nombre)));

                $tallas = $this->input->post('tallas');
                $tags = $this->input->post('tags');
                $precio = $this->input->post('precio');
                $video = $this->input->post('video');


                $configup['upload_path'] = './img/productos/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/productos/'.$nm_grande;
                    $path_thumb = './img/productos/'.$nm_thumb;

                    resizeImage($original, 240, 240, $path_grande, "crop", 90);
                    resizeImage($original, 100, 100, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $add_producto = $this->admin_model->create_producto($categoria, $marca, $codigo, $nombre, $descripcion, $precio, $tallas, $video, $tags, $nm_grande, $nm_thumb, $url, $activo);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/productos_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/productos_agregar', $data);
                    return;
                }

                if($add_producto) {
                    $red = $this->config->base_url($this->admin."/productos");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/productos_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }

        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "productos";
            $data['seccion2']= "editar";

            if($id) {

                $data['categorias'] = $this->admin_model->get_categorias();
                $data['subcategorias'] = $this->admin_model->get_subcategorias_no_id();
                $data['cat_sel'] = $this->admin_model->get_producto_subcategorias($id);

                $data['marcas'] = $this->admin_model->get_marcas();

                $data['producto_info'] = $this->admin_model->get_producto($id);

                $this->form_validation->set_rules('nombre', '"nombre"', 'trim|required|min_length[2]|is_unique[marcas.marca]|max_length[255]|xss_clean');
                $this->form_validation->set_rules('codigo', '"codigo"', 'trim|max_length[50]|xss_clean');

                //$this->form_validation->set_rules('categoria', '"categoría"', 'is_natural_no_zero');
                $this->form_validation->set_message('is_natural_no_zero', 'Por favor, selecciona una %s');

                $this->form_validation->set_rules('marca', '"marca"', 'is_natural_no_zero');
                $this->form_validation->set_message('is_natural_no_zero', 'Por favor, selecciona una %s');

                $this->form_validation->set_rules('descripcion', '"descripción"', 'trim|xss_clean');

                $this->form_validation->set_rules('precio', '"precio"', 'trim|is_natural|xss_clean');
                $this->form_validation->set_rules('tallas', '"tallas"', 'trim|xss_clean');
                $this->form_validation->set_rules('tags', '"etiquetas"', 'trim|xss_clean');
                $this->form_validation->set_rules('video', '"video"', 'trim|xss_clean');

                if ($this->form_validation->run() == FALSE) {

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/productos_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;

                } else {
                    $delete_image = FALSE;
                    //$texto = $this->input->post('texto');
                    //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                    $activo = $this->input->post('activo');
                    $categoria = array_unique($this->input->post('categoria'));
                    $categoria = array_filter($categoria);

                    if(count($categoria) < 1 OR $categoria == 0) {
                        $data['error_imagen'] = 'Por favor, selecciona una categoría.';

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_agregar', $data);
                        return;
                    }


                    $marca = $this->input->post('marca');
                    $nombre = $this->input->post('nombre');
                    $codigo = $this->input->post('codigo');
                    $descripcion = $this->input->post('descripcion');
                    $url = url_title(strtolower(sustituir_acentos($nombre)));

                    $tallas = $this->input->post('tallas');
                    $tags = $this->input->post('tags');
                    $precio = $this->input->post('precio');
                    $video = $this->input->post('video');


                    $configup['upload_path'] = './img/productos/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();


                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/productos_editar', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/productos_editar', $data);
                            return;
                        }



                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                        $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                        $path_grande = './img/productos/'.$nm_grande;
                        $path_thumb = './img/productos/'.$nm_thumb;

                        resizeImage($original, 240, 240, $path_grande, "crop", 90);
                        resizeImage($original, 100, 100, $path_thumb, "crop", 90);

                        //      $imagen = $nm_grande;

                        eliminar_archivo($original);

                        $edit_producto = $this->admin_model->edit_producto($id, $categoria, $marca, $codigo, $nombre, $descripcion, $precio, $tallas, $video, $tags, $nm_grande, $nm_thumb, $url, $activo);

                        $delete_image = TRUE;

                    } else if($_FILES['imagen']['error'] == 4) {

                        $edit_producto = $this->admin_model->edit_producto($id, $categoria, $marca, $codigo, $nombre, $descripcion, $precio, $tallas, $video, $tags, FALSE, FALSE, $url, $activo);

                    } else {
                        $edit_producto = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_editar', $data);
                        return;
                    }

                    if($edit_producto) {
                        if($delete_image) {
                            $old_path = "./img/productos/".$data['producto_info']['thumb'];
                            eliminar_archivo($old_path);
                            $old_path = "./img/productos/".$data['producto_info']['imagen'];
                            eliminar_archivo($old_path);
                        }
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }
            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }









        } else if($pag == 'descargas') {
            $data['seccion1']= "productos";
            $data['seccion2']= "descargas";

            if($id) {
                $data['producto_info'] = $this->admin_model->get_producto($id);
                //$data['id_galerias'] = $data['galeria_info']['id_producto'];
                $data['l_descargas'] = $this->admin_model->get_descargas($id);

                $this->form_validation->set_rules('nombre', '"nombre"', 'trim|required|min_length[2]|max_length[255]|xss_clean');
                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    if($data['producto_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_descargas', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $nombre = $this->input->post('nombre');

                    $configup['upload_path'] = './archivos/';
                    $configup['allowed_types'] = 'pdf|doc|docx|zip|xls';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;
                    // $config['file_name'] = 'file' . time();

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();


                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $archivo = $uniqid.$data['upload_data']['file_ext'];

                        $path = './archivos/'.$archivo;

                        $rename = rename($original, $path);

                        if($rename) {
                            eliminar_archivo($original);
                        }


                        $add_descarga = $this->admin_model->create_descarga($id, $nombre, $archivo);

                    } else if($_FILES['imagen']['error'] == 4) {

                        $data['error_imagen'] = 'No has seleccionado un archivo para subir.';

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_descargas', $data);
                        return;

                    } else {
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_descargas', $data);
                        return;
                    }

                    if($add_descarga) {
                        $red = $this->config->base_url($this->admin."/productos/descargas/".$id);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_descargas', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }
                }
            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }
        } else if($pag == 'info') {
            $data['seccion1']= "productos";
            $data['seccion2']= "info";

            if($id) {
                $data['producto_info'] = $this->admin_model->get_producto($id);
                //$data['id_galerias'] = $data['galeria_info']['id_producto'];
                $data['l_info'] = $this->admin_model->get_infos($id);

                $this->form_validation->set_rules('nombre', '"nombre"', 'trim|required|min_length[2]|max_length[255]|xss_clean');
                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    if($data['producto_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_info', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $nombre = $this->input->post('nombre');
                    $tipo = $this->input->post('tipo');
                    if($tipo == 1) {
                        $contenido = trim($this->input->post('contenido_1'));
                    } else if($tipo == 2) {
                        $contenido = trim($this->input->post('contenido_2'));
                    }

                    $add_info = $this->admin_model->create_info($id, $tipo, $nombre, $contenido);

                    if($add_info) {
                        $red = $this->config->base_url($this->admin."/productos/info/".$id);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_info', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }
                }
            } else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }
        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "productos";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['producto_info'] = $this->admin_model->get_producto($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['producto_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_producto = $this->admin_model->eliminar_producto($id);

                    if($eliminar_producto) {

                        $old_path_img = "./img/productos/".$data['producto_info']['imagen'];
                        $old_path_thumb = "./img/productos/".$data['producto_info']['thumb'];

                        eliminar_archivo($old_path_img);
                        eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/productos");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/productos_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/productos");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "productos";
            $data['seccion2']= "ordenar";

            $data['l_productos'] = $this->admin_model->get_productos();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/productos_ordenar', $data);
            return;

        } else {

            $config['base_url'] = $this->config->base_url().'admin/productos';
            $config['total_rows'] = $this->admin_model->ob_numero_productos();
            $config['per_page'] = 50;
            $config['num_links'] = 10;
            $config['full_tag_open'] = '<div class="paginacion">';
            $config['full_tag_close'] = '</div>';
            $config['next_link'] = 'Siguiente &#9654;';
            $config['prev_link'] = '&#9664; Anterior';
            $config['first_link'] = FALSE;
            $config['last_link'] = FALSE;
            $config['cur_tag_open'] = '<span class="activo">';
            $config['cur_tag_close'] = '</span>';
            //$config['num_links'] = '';
            //$config[''] = '';

            $this->pagination->initialize($config);
            //$data['lista_productos'] = $this->admin_model->get_productos();
            $data['lista_productos'] = $this->admin_model->ob_productos($config['per_page'], $this->uri->segment(3));

            $data['resultados'] = mostrando($config['total_rows'], $config['per_page'], intval($this->uri->segment(3)));
            //$data['resultados'] = mostrando(count($data['lista_productos']), 1000);

            $data['seccion1']= "productos";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/productos_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }

    public function buscar($num = 0)
    {

        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        if(isset($_GET['q'])) {
            $q = validar_busqueda(trim($_GET['q']));

            /*$config['base_url'] = $this->config->base_url().'admin/buscar/';
            $config['total_rows'] = $this->admin_model->ob_numero_productos_buscar($q);
            $config['per_page'] = 5;
            $config['num_links'] = 10;
            $config['full_tag_open'] = '<div class="paginacion">';
            $config['full_tag_close'] = '</div>';
            $config['next_link'] = 'Siguiente &#9654;';
            $config['prev_link'] = '&#9664; Anterior';
            $config['first_link'] = FALSE;
            $config['last_link'] = FALSE;
            $config['cur_tag_open'] = '<span class="activo">';
            $config['cur_tag_close'] = '</span>';

            $this->pagination->initialize($config);
            */
            $data['lista_productos'] = $this->admin_model->ob_productos_buscar($q, 100, 0);
            $data['resultados'] = mostrando(count($data['lista_productos']), 1000);
            //$data['resultados'] = mostrando($config['total_rows'], $config['per_page'], intval($this->uri->segment(3)));


            //$data['productos'] = $this->site_model->get_productos_buscar($q, TRUE);
            //shuffle($data['productos']);
            $data['q'] = $q;

            $data['seccion1']= "productos";
            $data['seccion2']= "buscar";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/buscar_lista', $data);
            return;
        }

    }


    public function marcas($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "marcas";
            $data['seccion2']= "agregar";

            //$this->form_validation->set_rules('texto', '"texto"', 'trim|max_length[300]|xss_clean');
            $this->form_validation->set_rules('marca', '"marca"', 'trim|required|min_length[2]|is_unique[marcas.marca]|max_length[255]|xss_clean');
            $this->form_validation->set_rules('descripcion', '"descripción"', 'trim|max_length[255]|xss_clean');
            $this->form_validation->set_rules('description', '"descripción en inglés"', 'trim|max_length[255]|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/marcas_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                //$texto = $this->input->post('texto');

                //$activo = $this->input->post('activo');
                $marca = $this->input->post('marca');
                $descripcion = $this->input->post('descripcion');
                $description = $this->input->post('description');
                $url = url_title(strtolower(sustituir_acentos($marca)));
                $activo = $this->input->post('activo');


                $configup['upload_path'] = './img/marcas/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();

                    $this->load->library('image_lib');


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/marcas_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/marcas_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/marcas/'.$nm_grande;
                    $path_thumb = './img/marcas/'.$nm_thumb;

                    $ratio_i = $data['upload_data']['image_width']/$data['upload_data']['image_height'];
                    $ratio_general = 135/100;


                    $config = array();
                    $config['image_library'] = 'gd2';
                    $config['source_image'] = $data['upload_data']['full_path'];
                    $config['new_image'] = $nm_grande;
                    $config['maintain_ratio'] = TRUE;
                    if($ratio_i > $ratio_general) {
                        $config['master_dim'] = 'width';
                    } else {
                        $config['master_dim'] = 'height';
                    }
                    $config['width'] = 135;
                    $config['height'] = 100;
                    $this->image_lib->initialize($config);
                    $this->image_lib->resize();

                    $this->image_lib->clear();



                    $config = array();
                    $config['image_library'] = 'gd2';
                    $config['source_image'] = $data['upload_data']['full_path'];
                    $config['new_image'] = $nm_thumb;
                    $config['maintain_ratio'] = TRUE;
                    //  if($ratio_i > $ratio_general) {
                    $config['master_dim'] = 'width';
                    //  } else {
                    //     $config['master_dim'] = 'height';
                    //  }
                    $config['width'] = 100;
                    $config['height'] = 75;
                    $this->image_lib->initialize($config);
                    $this->image_lib->resize();

                    $this->image_lib->clear();
                    resizeImage($data['upload_data']['full_path'], 100, 75, $path_thumb, "crop", 90);


/*
                    if($ratio_i > $ratio_general) {
                        resizeImage($original, 196, 130, $path_grande, "portrait", 90);
                    } else {
                        resizeImage($original, 196, 130, $path_grande, "landscape", 90);
                    }
*/
                    //resizeImage($original, 194, 130, $path_grande, "crop", 90);
                    //resizeImage($original, 100, 100, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $add_marca = $this->admin_model->create_marca($marca, $descripcion, $description, $nm_grande, $nm_thumb, $url, $activo);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/marcas_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/marcas_agregar', $data);
                    return;
                }

                if($add_marca) {
                    $red = $this->config->base_url($this->admin."/marcas");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/marcas_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }

        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "marcas";
            $data['seccion2']= "editar";

            if($id) {

                $data['marca_info'] = $this->admin_model->get_marca($id);

                $this->form_validation->set_rules('marca', '"marca"', 'trim|required|min_length[2]|max_length[255]|xss_clean');
                $this->form_validation->set_rules('descripcion', '"descripción"', 'trim|max_length[255]|xss_clean');
                $this->form_validation->set_rules('description', '"descripción en inglés"', 'trim|max_length[255]|xss_clean');

                if ($this->form_validation->run() == FALSE) {

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/marcas_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;

                } else {
                    $delete_image = FALSE;
                    //$texto = $this->input->post('texto');

                    //$activo = $this->input->post('activo');
                    $marca = $this->input->post('marca');
                    $descripcion = $this->input->post('descripcion');
                    $description = $this->input->post('description');
                    $url = url_title(strtolower(sustituir_acentos($marca)));
                    $activo = $this->input->post('activo');


                    $configup['upload_path'] = './img/marcas/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();

                        $this->load->library('image_lib');

                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/marcas_editar', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/marcas_editar', $data);
                            return;
                        }



                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                        $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                        $path_grande = './img/marcas/'.$nm_grande;
                        $path_thumb = './img/marcas/'.$nm_thumb;

                        $ratio_i = $data['upload_data']['image_width']/$data['upload_data']['image_height'];
                        $ratio_general = 135/100;


                        $config = array();
                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $data['upload_data']['full_path'];
                        $config['new_image'] = $nm_grande;
                        $config['maintain_ratio'] = TRUE;
                        if($ratio_i > $ratio_general) {
                            $config['master_dim'] = 'width';
                        } else {
                            $config['master_dim'] = 'height';
                        }
                        $config['width'] = 135;
                        $config['height'] = 100;
                        $this->image_lib->initialize($config);
                        $this->image_lib->resize();

                        $this->image_lib->clear();



                        $config = array();
                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $data['upload_data']['full_path'];
                        $config['new_image'] = $nm_thumb;
                        $config['maintain_ratio'] = TRUE;
                        //  if($ratio_i > $ratio_general) {
                        $config['master_dim'] = 'width';
                        //  } else {
                        //     $config['master_dim'] = 'height';
                        //  }
                        $config['width'] = 100;
                        $config['height'] = 75;
                        $this->image_lib->initialize($config);
                        $this->image_lib->resize();

                        $this->image_lib->clear();
                        resizeImage($data['upload_data']['full_path'], 100, 75, $path_thumb, "crop", 90);
/*
                        resizeImage($original, 194, 194, $path_grande, "crop", 90);
                        resizeImage($original, 100, 100, $path_thumb, "crop", 90);
*/
                        //      $imagen = $nm_grande;

                        eliminar_archivo($original);

                        $edit_marca = $this->admin_model->edit_marca($id, $marca, $descripcion, $description, $nm_grande, $nm_thumb, $url, $activo);
                        $delete_image = TRUE;

                    } else if($_FILES['imagen']['error'] == 4) {

                        $edit_marca = $this->admin_model->edit_marca($id, $marca, $descripcion, $description, FALSE, FALSE, $url, $activo);

                    } else {
                        $edit_marca = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/marcas_editar', $data);
                        return;
                    }

                    if($edit_marca) {
                        if($delete_image) {
                            $old_path = "./img/marcas/".$data['marca_info']['thumb'];
                            eliminar_archivo($old_path);
                        }
                        $red = $this->config->base_url($this->admin."/marcas");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/marcas_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }
            } else {
                $red = $this->config->base_url($this->admin."/marcas");
                redirect($red, "location");
                return;
            }









        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "marcas";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['marca_info'] = $this->admin_model->get_marca($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];
                $data['has'] = $query = $this->db->get_where('productos', array('id_marca' => $id))->num_rows();

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['marca_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/marcas_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/marcas");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_marca = $this->admin_model->eliminar_marca($id);

                    if($eliminar_marca) {

                        $old_path_img = "./img/marcas/".$data['marca_info']['imagen'];
                        $old_path_thumb = "./img/marcas/".$data['marca_info']['thumb'];

                        eliminar_archivo($old_path_img);
                        eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/marcas");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/marcas_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/marcas");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "marcas";
            $data['seccion2']= "ordenar";

            $data['l_marcas'] = $this->admin_model->get_marcas();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/marcas_ordenar', $data);
            return;

        } else {

            $data['lista_marcas'] = $this->admin_model->get_marcas();

            $data['resultados'] = mostrando(count($data['lista_marcas']), 1000);

            $data['seccion1']= "marcas";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/marcas_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }




    public function patrocinadores($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "patrocinadores";
            $data['seccion2']= "agregar";

            //$this->form_validation->set_rules('texto', '"texto"', 'trim|max_length[300]|xss_clean');
            $this->form_validation->set_rules('nombre', '"nombre"', 'trim|required|min_length[2]|max_length[255]|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/patrocinadores_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                //$texto = $this->input->post('texto');
                //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                //$activo = $this->input->post('activo');
                $nombre = $this->input->post('nombre');


                $configup['upload_path'] = './img/patrocinadores/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();

                    $this->load->library('image_lib');


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/patrocinadores_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/patrocinadores_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/patrocinadores/'.$nm_grande;
                    $path_thumb = './img/patrocinadores/'.$nm_thumb;

                    /*

                    resizeImage($original, 326, 283, $path_grande, "crop", 90);
                    resizeImage($original, 100, 87, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;
                    */

                    $ratio_i = $data['upload_data']['image_width']/$data['upload_data']['image_height'];
                    $ratio_general = 135/100;


                    $config = array();
                    $config['image_library'] = 'gd2';
                    $config['source_image'] = $data['upload_data']['full_path'];
                    $config['new_image'] = $nm_grande;
                    $config['maintain_ratio'] = TRUE;
                    if($ratio_i > $ratio_general) {
                        $config['master_dim'] = 'width';
                    } else {
                        $config['master_dim'] = 'height';
                    }
                    $config['width'] = 250;
                    $config['height'] = 185;
                    $this->image_lib->initialize($config);
                    $this->image_lib->resize();

                    $this->image_lib->clear();



                    $config = array();
                    $config['image_library'] = 'gd2';
                    $config['source_image'] = $data['upload_data']['full_path'];
                    $config['new_image'] = $nm_thumb;
                    $config['maintain_ratio'] = TRUE;
                    //  if($ratio_i > $ratio_general) {
                    $config['master_dim'] = 'width';
                    //  } else {
                    //     $config['master_dim'] = 'height';
                    //  }
                    $config['width'] = 100;
                    $config['height'] = 75;
                    $this->image_lib->initialize($config);
                    $this->image_lib->resize();

                    $this->image_lib->clear();
                    resizeImage($data['upload_data']['full_path'], 100, 75, $path_thumb, "crop", 90);




                    eliminar_archivo($original);

                    $add_patrocinador = $this->admin_model->create_patrocinador($nombre, $nm_grande, $nm_thumb);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/patrocinadores_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/patrocinadores_agregar', $data);
                    return;
                }

                if($add_patrocinador) {
                    $red = $this->config->base_url($this->admin."/patrocinadores");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/patrocinadores_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }

        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "patrocinadores";
            $data['seccion2']= "editar";

            if($id) {

                $data['patrocinador_info'] = $this->admin_model->get_patrocinador($id);

                $this->form_validation->set_rules('nombre', '"nombre"', 'trim|required|min_length[2]|max_length[255]|xss_clean');

                if ($this->form_validation->run() == FALSE) {

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/patrocinadores_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;

                } else {
                    $delete_image = FALSE;
                    //$texto = $this->input->post('texto');
                    //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                    //$activo = $this->input->post('activo');
                    $nombre = $this->input->post('nombre');


                    $configup['upload_path'] = './img/patrocinadores/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();

                        $this->load->library('image_lib');

                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/patrocinadores_editar', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/patrocinadores_editar', $data);
                            return;
                        }



                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                        $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                        $path_grande = './img/patrocinadores/'.$nm_grande;
                        $path_thumb = './img/patrocinadores/'.$nm_thumb;
/*
                        resizeImage($original, 326, 283, $path_grande, "crop", 90);
                        resizeImage($original, 100, 87, $path_thumb, "crop", 90);

                        //      $imagen = $nm_grande;
*/
                        $ratio_i = $data['upload_data']['image_width']/$data['upload_data']['image_height'];
                        $ratio_general = 135/100;


                        $config = array();
                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $data['upload_data']['full_path'];
                        $config['new_image'] = $nm_grande;
                        $config['maintain_ratio'] = TRUE;
                        if($ratio_i > $ratio_general) {
                            $config['master_dim'] = 'width';
                        } else {
                            $config['master_dim'] = 'height';
                        }
                        $config['width'] = 250;
                        $config['height'] = 185;
                        $this->image_lib->initialize($config);
                        $this->image_lib->resize();

                        $this->image_lib->clear();



                        $config = array();
                        $config['image_library'] = 'gd2';
                        $config['source_image'] = $data['upload_data']['full_path'];
                        $config['new_image'] = $nm_thumb;
                        $config['maintain_ratio'] = TRUE;
                        //  if($ratio_i > $ratio_general) {
                        $config['master_dim'] = 'width';
                        //  } else {
                        //     $config['master_dim'] = 'height';
                        //  }
                        $config['width'] = 100;
                        $config['height'] = 75;
                        $this->image_lib->initialize($config);
                        $this->image_lib->resize();

                        $this->image_lib->clear();
                        resizeImage($data['upload_data']['full_path'], 100, 75, $path_thumb, "crop", 90);


                        eliminar_archivo($original);

                        $edit_patrocinador = $this->admin_model->edit_patrocinador($id, $nombre, $nm_grande, $nm_thumb);
                        $delete_image = TRUE;

                    } else if($_FILES['imagen']['error'] == 4) {

                        $edit_patrocinador = $this->admin_model->edit_patrocinador($id, $nombre, FALSE, FALSE);

                    } else {
                        $edit_patrocinador = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/patrocinadores_editar', $data);
                        return;
                    }

                    if($edit_patrocinador) {
                        if($delete_image) {
                            $old_path = "./img/patrocinadores/".$data['patrocinador_info']['thumb'];
                            eliminar_archivo($old_path);
                        }
                        $red = $this->config->base_url($this->admin."/patrocinadores");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/patrocinadores_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }
            } else {
                $red = $this->config->base_url($this->admin."/patrocinadores");
                redirect($red, "location");
                return;
            }









        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "patrocinadores";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['patrocinador_info'] = $this->admin_model->get_patrocinador($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['patrocinador_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/patrocinadores_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/patrocinadores");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_patrocinador = $this->admin_model->eliminar_patrocinador($id);

                    if($eliminar_patrocinador) {

                        $old_path_img = "./img/patrocinadores/".$data['patrocinador_info']['imagen'];
                        $old_path_thumb = "./img/patrocinadores/".$data['patrocinador_info']['thumb'];

                        eliminar_archivo($old_path_img);
                        eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/patrocinadores");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/patrocinadores_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/patrocinadores");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "patrocinadores";
            $data['seccion2']= "ordenar";

            $data['l_patrocinadores'] = $this->admin_model->get_patrocinadores();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/patrocinadores_ordenar', $data);
            return;

        } else {

            $data['lista_patrocinadores'] = $this->admin_model->get_patrocinadores();

            $data['resultados'] = mostrando(count($data['lista_patrocinadores']), 1000);

            $data['seccion1']= "patrocinadores";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/patrocinadores_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }



    public function banners($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "banners";
            $data['seccion2']= "agregar";

            $this->form_validation->set_rules('texto', '"texto"', 'trim|max_length[300]|xss_clean');
            $this->form_validation->set_rules('texto_2', '"texto 2"', 'trim|max_length[250]|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/banners_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                $texto = $this->input->post('texto');
                $texto_2 = $this->input->post('texto_2');
                $producto = $this->input->post('hq');
                //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                $activo = $this->input->post('activo');


                $configup['upload_path'] = './img/banners/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/banners_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/banners_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/banners/'.$nm_grande;
                    $path_thumb = './img/banners/'.$nm_thumb;

                    resizeImage($original, 1400, 700, $path_grande, "crop", 90);
                    resizeImage($original, 150, 75, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $add_banner = $this->admin_model->create_banner($texto, $texto_2, $nm_grande, $nm_thumb, $producto, $activo);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/banners_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/banners_agregar', $data);
                    return;
                }

                if($add_banner) {
                    $red = $this->config->base_url($this->admin."/banners");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/banners_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }

        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "banners";
            $data['seccion2']= "editar";

            if($id) {

            $data['banner_info'] = $this->admin_model->get_banner($id);
            if($data['banner_info']['producto']) {
                    $data['producto'] = $this->admin_model->get_producto($data['banner_info']['producto']);
                } else {
                    $data['producto'] = FALSE;
                }

            $this->form_validation->set_rules('texto', '"texto"', 'trim|max_length[300]|xss_clean');
            $this->form_validation->set_rules('texto_2', '"texto 2"', 'trim|max_length[250]|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/banners_editar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {
                $delete_image = FALSE;
                $texto = $this->input->post('texto');
                $texto_2 = $this->input->post('texto_2');
                $producto = $this->input->post('hq');
                //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                $activo = $this->input->post('activo');


                $configup['upload_path'] = './img/banners/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/banners_editar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/banners_editar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/banners/'.$nm_grande;
                    $path_thumb = './img/banners/'.$nm_thumb;

                    resizeImage($original, 1400, 700, $path_grande, "crop", 90);
                    resizeImage($original, 150, 75, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $edit_banner = $this->admin_model->edit_banner($id, $texto, $texto_2, $nm_grande, $nm_thumb, $producto, $activo);
                    $delete_image = TRUE;

                } else if($_FILES['imagen']['error'] == 4) {

                    $edit_banner = $this->admin_model->edit_banner($id, $texto, $texto_2, FALSE, FALSE, $producto, $activo);

                } else {
                    $edit_banner = FALSE;
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/banners_editar', $data);
                    return;
                }

                if($edit_banner) {
                    if($delete_image) {
                        $old_path = "./img/banners/".$data['banner_info']['thumb'];
                        eliminar_archivo($old_path);
                    }
                    $red = $this->config->base_url($this->admin."/banners");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/banners_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }
        } else {
                $red = $this->config->base_url($this->admin."/banners");
                redirect($red, "location");
                return;
            }


        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "banners";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['banner_info'] = $this->admin_model->get_banner($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['banner_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/banners_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/banners");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_banner = $this->admin_model->eliminar_banner($id);

                    if($eliminar_banner) {

                        $old_path_img = "./img/banners/".$data['banner_info']['imagen'];
                        $old_path_thumb = "./img/banners/".$data['banner_info']['thumb'];

                        eliminar_archivo($old_path_img);
                        eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/banners");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/banners_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/banners");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "banners";
            $data['seccion2']= "ordenar";

            $data['l_banners'] = $this->admin_model->get_banners();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/banners_ordenar', $data);
            return;

        } else {

            $data['lista_banners'] = $this->admin_model->get_banners();

            $data['resultados'] = mostrando(count($data['lista_banners']), 1000);

            $data['seccion1']= "banners";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/banners_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }


    // Promociones Administrables-------------------------------------------------------------------------------------------
    public function promociones_flyer($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "promociones_flyer";
            $data['seccion2']= "agregar";

            //$data['productos'] = $this->admin_model->get_productos();

            $this->form_validation->set_rules('nombre', '"nombre"', 'required');
            //$this->form_validation->set_rules('descripcion', '"descripción"', 'trim|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/promociones_flyer_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                $enlace = $this->input->post('enlace');
                $nombre = $this->input->post('nombre');
                // $descripcion = $this->input->post('descripcion');
                // $producto_1 = $this->input->post('hq1');
                // $producto_2 = $this->input->post('hq2');
                $url = url_title(strtolower(sustituir_acentos($nombre)));
                $activo = $this->input->post('activo');


                $configup['upload_path'] = './img/flyers/';
                $configup['allowed_types'] = 'jpg|JPG|jpeg|JPEG|png|PNG';
                $configup['max_size']   = '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {

                    $data['upload_data'] = $this->upload->data();

                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_flyer_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_flyer_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/flyers/'.$nm_grande;
                    $path_thumb = './img/flyers/'.$nm_thumb;

                    resizeImage($original, 418, 302, $path_grande, "crop", 90);
                    resizeImage($original, 200, 144, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $add_promocion = $this->admin_model->create_flyer($nombre, $enlace, $nm_grande, $nm_thumb, $url, $activo);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_flyer_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_flyer_agregar', $data);
                    return;
                }

                if($add_promocion) {
                    $red = $this->config->base_url($this->admin."/promociones_flyer");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_flyer_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }

        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "promociones_flyer";
            $data['seccion2']= "editar";

            if($id) {

                $data['promo_info'] = $this->admin_model->get_flyer($id);
                //$data['productos'] = $this->admin_model->get_productos();

                // if($data['promo_info']['producto_1']) {
                //     $data['producto_1'] = $this->admin_model->get_producto($data['promo_info']['producto_1']);
                // } else {
                //     $data['producto_1'] = FALSE;
                // }

                // if($data['promo_info']['producto_2']) {
                //     $data['producto_2'] = $this->admin_model->get_producto($data['promo_info']['producto_2']);
                // } else {
                //     $data['producto_2'] = FALSE;
                // }

                $this->form_validation->set_rules('nombre', '"nombre"', 'trim|max_length[300]|xss_clean');
                //$this->form_validation->set_rules('descripcion', '"descripción"', 'trim|xss_clean');

                if ($this->form_validation->run() == FALSE) {

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/promociones_flyer_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;

                } else {
                    $delete_image = FALSE;
                    $nombre = $this->input->post('nombre');
                    $enlace = $this->input->post('enlace');
                    // $producto_1 = $this->input->post('hq1');;
                    // $producto_2 = $this->input->post('hq2');
                    $url = url_title(strtolower(sustituir_acentos($nombre)));
                    $activo = $this->input->post('activo');


                    $configup['upload_path'] = './img/flyers/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']   = '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();


                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/promociones_flyer_editar', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                            //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/promociones_flyer_editar', $data);
                            return;
                        }



                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                        $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                        $path_grande = './img/flyers/'.$nm_grande;
                        $path_thumb = './img/flyers/'.$nm_thumb;

                        resizeImage($original, 418, 302, $path_grande, "crop", 90);
                        resizeImage($original, 200, 144, $path_thumb, "crop", 90);

                        //      $imagen = $nm_grande;

                        eliminar_archivo($original);

                        $edit_promocion = $this->admin_model->edit_flyer($id, $nombre, $enlace, $nm_grande, $nm_thumb, $url, $activo);
                        $delete_image = TRUE;

                    } else if($_FILES['imagen']['error'] == 4) {

                        $edit_promocion = $this->admin_model->edit_flyer($id, $nombre, $enlace, FALSE, FALSE, $url, $activo);

                    } else {
                        $edit_promocion = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_flyer_editar', $data);
                        return;
                    }

                    if($edit_promocion) {
                        if($delete_image) {
                            $old_path = "./img/flyers/".$data['promo_info']['thumb'];
                            $old_image = "./img/flyers/".$data['promo_info']['imagen'];
                            eliminar_archivo($old_path);
                            eliminar_archivo($old_image);
                        }
                        $red = $this->config->base_url($this->admin."/promociones_flyer");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_flyer_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }
            } else {
                $red = $this->config->base_url($this->admin."/promociones_flyer");
                redirect($red, "location");
                return;
            }


        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "promociones_flyer";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['promo_info'] = $this->admin_model->get_flyer($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['promo_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_flyer_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/promociones_flyer");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_promocion = $this->admin_model->eliminar_flyer($id);

                    if($eliminar_promocion) {

                        $old_path_img = "./img/flyers/".$data['promo_info']['imagen'];
                        $old_path_thumb = "./img/flyers/".$data['promo_info']['thumb'];

                        eliminar_archivo($old_path_img);
                        eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/promociones_flyer");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/promociones_flyer_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/promociones");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "promociones_flyer";
            $data['seccion2']= "ordenar";

            $data['l_promociones'] = $this->admin_model->get_promociones_flyer();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/promociones_flyer_ordenar', $data);
            return;

        } else {

            $data['lista_promociones'] = $this->admin_model->get_promociones_flyer();

            $data['resultados'] = mostrando(count($data['lista_promociones']), 1000);

            $data['seccion1']= "promociones_flyer";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/promociones_flyer_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }



    // Video Administrable--------------------------------------------------------------------------------------------------------------------------
    public function video($pag = FALSE, $id = FALSE) {
        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "video";
            $data['seccion2']= "agregar";

            $this->form_validation->set_rules('texto', '"texto"', 'trim|max_length[300]|xss_clean');
            $this->form_validation->set_rules('texto_2', '"texto 2"', 'trim|max_length[250]|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/video_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {

                $texto = $this->input->post('texto');
                $texto_2 = $this->input->post('texto_2');
                $producto = $this->input->post('hq');
                //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                $activo = $this->input->post('activo');


                $configup['upload_path'] = './img/video/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']   = '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/video_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/video_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/video/'.$nm_grande;
                    $path_thumb = './img/video/'.$nm_thumb;

                    resizeImage($original, 1400, 700, $path_grande, "crop", 90);
                    resizeImage($original, 150, 75, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $add_banner = $this->admin_model->create_banner($texto, $texto_2, $nm_grande, $nm_thumb, $producto, $activo);

                } else if($_FILES['imagen']['error'] == 4) {

                    $data['error_imagen'] = 'Por favor, agrega una imagen.';

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/video_agregar', $data);
                    return;

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/video_agregar', $data);
                    return;
                }

                if($add_banner) {
                    $red = $this->config->base_url($this->admin."/video");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/video_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }
        // Editar ----------------------------------------------------
        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "video";
            $data['seccion2']= "editar";

            if($id) {

            $data['video_info'] = $this->admin_model->get_video($id);
            /*if($data['video_info']['producto']) {
                    $data['producto'] = $this->admin_model->get_producto($data['video_info']['producto']);
                } else {
                    $data['producto'] = FALSE;
                }*/

            $this->form_validation->set_rules('video', '"video"', 'trim|required|xss_clean');

            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/video_editar', $data);
                //$this->load->view('admin/footer', $data);
                return;

            } else {
                $delete_image = FALSE;
                $video = $this->input->post('video');
                $autoplay = $this->input->post('autoplay');
                $vloop = $this->input->post('vloop');
                $mute = $this->input->post('mute');
                //$url = url_title(strtolower(sustituir_acentos($subcategoria)));
                $activo = $this->input->post('activo');


/*                $configup['upload_path'] = './img/video/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']   = '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";

                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/video_editar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/video_editar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    $nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/video/'.$nm_grande;
                    $path_thumb = './img/video/'.$nm_thumb;

                    resizeImage($original, 1400, 700, $path_grande, "crop", 90);
                    resizeImage($original, 150, 75, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);

                    $edit_banner = $this->admin_model->edit_banner($id, $texto, $texto_2, $nm_grande, $nm_thumb, $producto, $activo);
                    $delete_image = false;

                } else if($_FILES['imagen']['error'] == 4) {
                    //codigo
                    $edit_video = $this->admin_model->edit_video($id, $video, FALSE, $autoplay, $mute, $vloop, $activo);
                    //codigo
                } else {
                    $edit_banner = FALSE;
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/video_editar', $data);
                    return;
                }*/

                //codigo
                $edit_video = $this->admin_model->edit_video($id, $video, FALSE, $autoplay, $mute, $vloop, $activo);
                //codigo

                if($edit_video) {
                    if($delete_image) {
                        $old_path = "./img/video/".$data['video_info']['thumb'];
                        eliminar_archivo($old_path);
                    }
                    $red = $this->config->base_url($this->admin."/video");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/video_editar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }
        } else {
                $red = $this->config->base_url($this->admin."/video");
                redirect($red, "location");
                return;
            }

        // Eliminar -----------------------------------------------
        } else if($pag == "eliminar") {

            $id = validar_id($id);

            $data['seccion1']= "video";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['video_info'] = $this->admin_model->get_video($id);
                //$data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['video_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/video_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/video");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_banner = $this->admin_model->eliminar_banner($id);

                    if($eliminar_banner) {

                        $old_path_img = "./img/video/".$data['video_info']['imagen'];
                        $old_path_thumb = "./img/video/".$data['video_info']['thumb'];

                        eliminar_archivo($old_path_img);
                        eliminar_archivo($old_path_thumb);

                        $red = $this->config->base_url($this->admin."/video");
                        redirect($red, "location");
                        return;

                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/video_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }

            }  else {
                $red = $this->config->base_url($this->admin."/video");
                redirect($red, "location");
                return;
            }
        //Ordenar ------------------------------------------------------------
        }  else if($pag == "ordenar") {

            $data['seccion1']= "video";
            $data['seccion2']= "ordenar";

            $data['l_video'] = $this->admin_model->get_video();

            $this->load->view('admin/header', $data);
            $this->load->view('admin/video_ordenar', $data);
            return;

        } else {

            $data['lista_video'] = $this->admin_model->get_videos();

            $data['resultados'] = mostrando(count($data['lista_video']), 1000);

            $data['seccion1']= "video";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/video_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }

    }
    //Video Administrable----------------------------------------------------------------------------------------------------------------------------








    public function categorias($pag = FALSE, $id = FALSE) {

        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }


        if($pag == "agregar") {
            $data['seccion1']= "categorias";
            $data['seccion2']= "agregar";



            $this->form_validation->set_rules('categoria', '"categoria"', 'trim|required|min_length[3]|is_unique[categorias.categoria]|max_length[40]|xss_clean');




            if ($this->form_validation->run() == FALSE) {

                $this->load->view('admin/header', $data);
                $this->load->view('admin/categorias_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;
            } else {
                $categoria = $this->input->post('categoria');
                $url = url_title(strtolower(sustituir_acentos($categoria)));
                $activo = $this->input->post('activo');
                $add_cat = $this->admin_model->create_categoria($categoria, $url, $activo);

                if($add_cat) {
                    $red = $this->config->base_url($this->admin."/categorias");
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/categorias_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }




        } else if($pag == "editar") {

            $id = validar_id($id);

            $data['seccion1']= "categorias";
            $data['seccion2']= "editar";


            if($id) {

                $data['cat_info'] = $this->admin_model->get_categoria($id);

                $this->form_validation->set_rules('categoria', '"categoria"', 'trim|required|min_length[3]|max_length[40]|xss_clean');

                if ($this->form_validation->run() == FALSE) {

                    if($data['cat_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/categorias_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/categorias");
                        redirect($red, "location");
                        return;
                    }

                } else {
                    $categoria = $this->input->post('categoria');
                    $url = url_title(strtolower(sustituir_acentos($categoria)));
                    $activo = $this->input->post('activo');
                    $edit_cat = $this->admin_model->edit_categoria($id, $categoria, $url, $activo);

                    if($edit_cat) {
                        $red = $this->config->base_url($this->admin."/categorias");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/categorias_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }

            } else {
                $red = $this->config->base_url($this->admin."/categorias");
                redirect($red, "location");
                return;
            }






        } else if($pag == "eliminar") {



            $id = validar_id($id);

            $data['seccion1']= "categorias";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['cat_info'] = $this->admin_model->get_categoria($id);
                $data['has'] = $query = $this->db->get_where('subcategorias', array('id_categoria' => $id))->num_rows();

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['cat_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/categorias_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/categorias");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_cat = $this->admin_model->eliminar_categoria($id);

                    if($eliminar_cat) {
                        $red = $this->config->base_url($this->admin."/categorias");
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/categorias_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/categorias");
                redirect($red, "location");
                return;
            }



        }  else if($pag == "ordenar") {

            $data['seccion1']= "categorias";
            $data['seccion2']= "ordenar";

            $data['l_categorias'] = $this->admin_model->get_todas_categorias();

            //$data['city_info'] = $this->admin_model->get_ciudad($id);
            //$data['usuarios_cd'] = $query = $this->db->get_where('usuarios', array('t_ciudad_id' => $data['city_info']['id']))->num_rows();


            //if($data['city_info']) {
            $this->load->view('admin/header', $data);
            $this->load->view('admin/categorias_ordenar', $data);
            //$this->load->view('admin/footer', $data);
            return;
            /*} else {
                $red = $this->config->base_url().'admin/ciudades';
                redirect($red, "location");
                return;
            }*/

        } else {

            $config['base_url'] = $this->config->base_url($this->admin.'categorias');
            $config['total_rows'] = $this->db->get('categorias')->num_rows();
            $config['per_page'] = 50;
            $config['num_links'] = 10;
            $config['full_tag_open'] = '<div class="paginacion">';
            $config['full_tag_close'] = '</div>';
            $config['next_link'] = 'Siguiente &#9654;';
            $config['prev_link'] = '&#9664; Anterior';
            $config['first_link'] = FALSE;
            $config['last_link'] = FALSE;
            $config['cur_tag_open'] = '<span class="activo">';
            $config['cur_tag_close'] = '</span>';
            //$config['num_links'] = '';
            //$config[''] = '';

            $this->pagination->initialize($config);
//            $data['records'] = $this->db->get('categorias', $config['per_page'], $this->uri->segment(3));
            $data['lista_categorias'] = $this->admin_model->get_categorias($config['per_page'], $this->uri->segment(3));



            $data['resultados'] = mostrando($config['total_rows'], $config['per_page'], intval($this->uri->segment(3)));

            //           $data['lista_categorias'] = $this->admin_model->get_categorias(10, 0);

            //           $data['seg'] = $this->uri->segment(3);
            $data['seccion1']= "categorias";
            $data['seccion2']= "lista";
            $this->load->view('admin/header', $data);
            $this->load->view('admin/categorias_lista', $data);
            //$this->load->view('admin/footer', $data);
            return;
        }





    }


    public function subcategorias($pag = FALSE, $id = FALSE) {

        if($this->session->userdata('estatus') != 'admin') {
            $dir = $this->admin;
            redirect($dir, "location");
            return;
        }

        if($pag == "agregar") {

            $id = validar_id($id);

            $data['seccion1']= "categorias";
            $data['seccion2']= "agregar";

            if($id) {
                $cat = $this->admin_model->get_categoria($id);
                $data['id_subcategoria'] = $id;
            }


            if($id AND $cat) {


            $this->form_validation->set_rules('subcategoria', '"subcategoria"', 'trim|required|min_length[3]|max_length[40]|xss_clean');




            if ($this->form_validation->run() == FALSE) {
                $data['cat'] = $cat;

                $this->load->view('admin/header', $data);
                $this->load->view('admin/subcategorias_agregar', $data);
                //$this->load->view('admin/footer', $data);
                return;
            } else {
                $subcategoria = $this->input->post('subcategoria');
                $url = url_title(strtolower(sustituir_acentos($subcategoria)));
                $activo = $this->input->post('activo');


                $configup['upload_path'] = './img/categorias/';
                $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                $configup['max_size']	= '5120';
                //$configup['max_width']  = '1024';
                //$configup['max_height']  = '768';
                $configup['encrypt_name'] = TRUE;

                $this->load->library('upload', $configup);
                $img = "imagen";


                if($this->upload->do_upload($img)) {
                    $data['upload_data'] = $this->upload->data();


                    if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                        $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_agregar', $data);
                        return;
                    }

                    if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                        $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';
                        //$data['usuario_info'] = $this->perfil_model->get_usuario_p($id);

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_agregar', $data);
                        return;
                    }



                    $original = $data['upload_data']['full_path'];

                    $uniqid = uniqid();
                    $nm_grande = $uniqid.$data['upload_data']['file_ext'];
                    //$nm_thumb = $uniqid.'_thumb'.$data['upload_data']['file_ext'];

                    $path_grande = './img/categorias/'.$nm_grande;
                    //$path_thumb = './img/tienda/'.$nm_thumb;

                    resizeImage($original, 150, 150, $path_grande, "crop", 90);
                    //resizeImage($original, 59, 59, $path_thumb, "crop", 90);

                    //      $imagen = $nm_grande;

                    eliminar_archivo($original);


/*
                    $config['image_library'] = 'gd2';
                    $config['source_image'] = $data['upload_data']['full_path'];
                    $imagen = $data['upload_data']['file_name'];
                    $config['maintain_ratio'] = TRUE;
                    $config['master_dim'] = 'width';
                    $config['width'] = 111;
                    $config['height'] = 93;
                    $this->load->library('image_lib', $config);
                    $this->image_lib->resize();
*/
                    $add_cat = $this->admin_model->create_subcategoria($id, $subcategoria, $url, $activo, $nm_grande);

                } else if($_FILES['imagen']['error'] == 4) {

                    $add_cat = $this->admin_model->create_subcategoria($id, $subcategoria, $url, $activo);

                } else {
                    $data['error_imagen'] = $this->upload->display_errors();

                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/subcategorias_agregar', $data);
                    return;
                }


                if($add_cat) {
                    $red = $this->config->base_url($this->admin."/subcategorias/".$id);
                    redirect($red, "location");
                    return;
                } else {
                    $this->load->view('admin/header', $data);
                    $this->load->view('admin/subcategorias_agregar', $data);
                    //$this->load->view('admin/footer', $data);
                    return;
                }

            }

        } else {
                $red = $this->config->base_url($this->admin."/categorias");
                redirect($red, "location");
                return;
            }


        } else if($pag == "editar") {
            $data['seccion1']= "categorias";
            $data['seccion2']= "editar";

            if($id) {

                $data['cat_info'] = $this->admin_model->get_subcategoria($id);
                $data['id_subcategoria'] = $data['cat_info']['id_categoria'];

                $this->form_validation->set_rules('subcategoria', '"subcategoria"', 'trim|required|min_length[3]|max_length[40]|xss_clean');

                if ($this->form_validation->run() == FALSE) {



                    if($data['cat_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/categorias");
                        redirect($red, "location");
                        return;
                    }

                } else {
                    $delete_image = FALSE;
                    $subcategoria = $this->input->post('subcategoria');
                    $url = url_title(strtolower(sustituir_acentos($subcategoria)));
                    $activo = $this->input->post('activo');

                    $configup['upload_path'] = './img/categorias/';
                    $configup['allowed_types'] = 'gif|jpg|png|jpeg';
                    $configup['max_size']	= '5120';
                    //$configup['max_width']  = '1024';
                    //$configup['max_height']  = '768';
                    $configup['encrypt_name'] = TRUE;

                    $this->load->library('upload', $configup);
                    $img = "imagen";

                    if($this->upload->do_upload($img)) {
                        $data['upload_data'] = $this->upload->data();


                        if(!isset($data['upload_data']['is_image']) OR !$data['upload_data']['is_image'] OR !isset($data['upload_data']['image_height']) OR !$data['upload_data']['image_height']) {

                            $data['error_imagen'] = 'Por favor, agrega una imagen válida en alguno de los siguientes formatos: jpg, png o gif. Y con un peso menor a los 5 megas.';

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/subcategorias_editar', $data);
                            return;
                        }

                        if(($data['upload_data']['image_height'] * $data['upload_data']['image_width'] * 4) > 170000000 OR $data['upload_data']['file_size'] > 5120) {
                            $data['error_imagen'] = 'La imagen que deseas agregar es demasiado grande. Por favor, intenta con una imagen diferente.';

                            $this->load->view('admin/header', $data);
                            $this->load->view('admin/subcategorias_editar', $data);
                            return;
                        }


                        $original = $data['upload_data']['full_path'];

                        $uniqid = uniqid();
                        $nm_grande = $uniqid.$data['upload_data']['file_ext'];

                        $path_grande = './img/categorias/'.$nm_grande;

                        resizeImage($original, 150, 150, $path_grande, "crop", 90);

                        eliminar_archivo($original);

                        $edit_cat = $this->admin_model->edit_subcategoria($id, $subcategoria, $url, $activo, $nm_grande);
                        $delete_image = TRUE;



                    } else if($_FILES['imagen']['error'] == 4) {
                        $edit_cat = $this->admin_model->edit_subcategoria($id, $subcategoria, $url, $activo);

                    } else {
                        $edit_cat = FALSE;
                        $data['error_imagen'] = $this->upload->display_errors();

                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_editar', $data);
                        return;
                    }






                    if($edit_cat) {
                        if($delete_image) {
                            $old_path = "./img/categorias/".$data['cat_info']['thumb'];
                            eliminar_archivo($old_path);
                        }
                        $red = $this->config->base_url($this->admin."/subcategorias/".$data['id_subcategoria']);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_editar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }

            } else {
                $red = $this->config->base_url($this->admin."/categorias");
                redirect($red, "location");
                return;
            }


        } else if($pag == "eliminar") {
            $data['seccion1']= "categorias";
            $data['seccion2']= "eliminar";

            if($id) {

                $data['cat_info'] = $this->admin_model->get_subcategoria($id);
                $data['id_subcategoria'] = $data['cat_info']['id_categoria'];
                $data['has'] = count($this->admin_model->get_productos_sub($id));

                $this->form_validation->set_rules('send', '"botón"', 'required');

                if ($this->form_validation->run() == FALSE) {

                    //$data['num_productos'] = $this->admin_model->get_categoria_num_productos($id);

                    if($data['cat_info']) {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    } else {
                        $red = $this->config->base_url($this->admin."/categorias");
                        redirect($red, "location");
                        return;
                    }

                } else {

                    $eliminar_cat = $this->admin_model->eliminar_subcategoria($id);

                    if($eliminar_cat) {
                        $red = $this->config->base_url($this->admin."/subcategorias/".$data['id_subcategoria']);
                        redirect($red, "location");
                        return;
                    } else {
                        $this->load->view('admin/header', $data);
                        $this->load->view('admin/subcategorias_eliminar', $data);
                        //$this->load->view('admin/footer', $data);
                        return;
                    }

                }




            }  else {
                $red = $this->config->base_url($this->admin."/categorias");
                redirect($red, "location");
                return;
            }

        } else if($pag == "ordenar") {

            $data['seccion1']= "categorias";
            $data['seccion2']= "ordenar";

            if($id) {

                $cat = $this->admin_model->get_categoria($id);
                $data['id_subcategoria'] = $id;

            }

            if($id AND $cat) {

                $data['l_subcategorias'] = $this->admin_model->get_todas_subcategorias($id);

                $this->load->view('admin/header', $data);
                $this->load->view('admin/subcategorias_ordenar', $data);
                return;


            } else {
                    $red = $this->config->base_url($this->admin."/categorias");
                    redirect($red, "location");
                    return;
            }



        } else {

            $pag = validar_id($pag);

            if($pag) {

                $data['cat_info'] = $this->admin_model->get_categoria($pag);

                $config['base_url'] = $this->config->base_url($this->admin.'subcategorias');
                $config['total_rows'] = $this->db->get_where('subcategorias', array('id_categoria' => $pag))->num_rows();
                $config['per_page'] = 50;
                $config['num_links'] = 10;
                $config['full_tag_open'] = '<div class="paginacion">';
                $config['full_tag_close'] = '</div>';
                $config['next_link'] = 'Siguiente &#9654;';
                $config['prev_link'] = '&#9664; Anterior';
                $config['first_link'] = FALSE;
                $config['last_link'] = FALSE;
                $config['cur_tag_open'] = '<span class="activo">';
                $config['cur_tag_close'] = '</span>';
                //$config['num_links'] = '';
                //$config[''] = '';

                $this->pagination->initialize($config);
//            $data['records'] = $this->db->get('categorias', $config['per_page'], $this->uri->segment(3));
                $data['lista_subcategorias'] = $this->admin_model->get_subcategorias($pag, $config['per_page'], $this->uri->segment(4));



                $data['resultados'] = mostrando($config['total_rows'], $config['per_page'], intval($this->uri->segment(4)));

                //           $data['lista_categorias'] = $this->admin_model->get_categorias(10, 0);

                //           $data['seg'] = $this->uri->segment(3);
                $data['seccion1']= "categorias";
                $data['seccion2']= "lista";
                $data['id_subcategoria'] = $pag;
                $this->load->view('admin/header', $data);
                $this->load->view('admin/subcategorias_lista', $data);
                //$this->load->view('admin/footer', $data);
                return;


            } else {
                $red = $this->config->base_url($this->admin."/categorias");
                redirect($red, "location");
                return;
            }
        }

    }



















}

/* End of file Admin.php */
/* Location: ./application/controllers/Admin.php */